/*
 * Decompiled with CFR 0.152.
 */
package com.nexagis.jawbone.filter;

import com.nexagis.jawbone.filter.TermFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public final class WildcardFilter
implements TermFilter {
    private List<String> fields = new ArrayList<String>(8);
    private boolean ignoreCase = false;

    private WildcardFilter() {
    }

    public WildcardFilter(String string, boolean bl) {
        this.ignoreCase = bl;
        this.parsePattern(string);
    }

    public boolean accept(String string) {
        if (string == null && this.fields == null) {
            return true;
        }
        if (string == null || this.fields == null) {
            return false;
        }
        return this.matchPattern(string);
    }

    public boolean matchPattern(String string) {
        if (this.ignoreCase) {
            if (this.fields == null || this.fields.size() == 0) {
                return true;
            }
            if (string == null || string.length() == 0) {
                return false;
            }
            return this.matchString(string.toUpperCase());
        }
        return this.matchString(string);
    }

    private boolean matchString(String string) {
        String string2;
        boolean bl = false;
        bl = this.fields == null || this.fields.size() == 0 ? true : (string == null || string.length() == 0 ? false : (this.fields.size() == 1 ? (null == (string2 = this.fields.get(0)) ? true : this.equalsWild(string, string2)) : this.findMatch(0, string, 0)));
        return bl;
    }

    private boolean findMatch(int n, String string, int n2) {
        boolean bl = false;
        if (n >= this.fields.size()) {
            return true;
        }
        String string2 = this.fields.get(n);
        if (n2 >= string.length()) {
            return string2 == null;
        }
        if (string2 == null) {
            if (n == 0) {
                return this.findMatch(1, string, 0);
            }
            return true;
        }
        if (n == this.fields.size() - 1) {
            return this.endsWithWild(string, string2);
        }
        int n3 = string2.length();
        int n4 = this.indexOfWild(string, string2, n2);
        while (n4 >= 0 && !bl) {
            if (n4 > n2 && n == 0) {
                return false;
            }
            bl = this.findMatch(n + 1, string, n4 + n3);
            if (bl) continue;
            ++n4;
            n4 = this.indexOfWild(string, string2, n4);
        }
        return bl;
    }

    private boolean equalsWild(String string, String string2) {
        boolean bl = true;
        if (string == null || string2 == null) {
            return false;
        }
        if (string2.indexOf("?") < 0) {
            return string.equals(string2);
        }
        if (string.length() != string2.length()) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n && bl; ++i) {
            char c = string.charAt(i);
            char c2 = string2.charAt(i);
            if (c2 == '?' || c2 == c) continue;
            bl = false;
        }
        return bl;
    }

    private boolean endsWithWild(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (string2.indexOf("?") < 0) {
            return string.endsWith(string2);
        }
        if (string.length() < string2.length()) {
            return false;
        }
        String string3 = string.substring(string.length() - string2.length());
        return this.equalsWild(string3, string2);
    }

    private int indexOfWild(String string, String string2, int n) {
        boolean bl = false;
        int n2 = n;
        if (string == null || string2 == null || n < 0) {
            return -1;
        }
        if (string2.indexOf("?") < 0) {
            return string.indexOf(string2, n);
        }
        int n3 = string.length();
        int n4 = string2.length();
        if (n4 + n > n3) {
            return -1;
        }
        int n5 = n;
        while (!bl && n4 + n5 <= n3) {
            String string3 = string.substring(n5, n5 + n4);
            if (this.equalsWild(string3, string2)) {
                n2 = n5;
                bl = true;
            }
            ++n5;
        }
        if (!bl) {
            return -1;
        }
        return n2;
    }

    protected void parsePattern(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (string.startsWith("*")) {
            this.fields.add(null);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "*");
        while (stringTokenizer.hasMoreTokens()) {
            if (this.ignoreCase) {
                this.fields.add(stringTokenizer.nextToken().toUpperCase());
                continue;
            }
            this.fields.add(stringTokenizer.nextToken());
        }
        if ((this.fields.size() > 1 || this.fields.size() == 1 && this.fields.get(0) != null) && string.endsWith("*")) {
            this.fields.add(null);
        }
    }
}

