% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worcs_badge.R
\name{check_worcs}
\alias{check_worcs}
\title{Evaluate project with respect to WORCS checklist}
\usage{
check_worcs(path = ".", verbose = TRUE)
}
\arguments{
\item{path}{Character. Path to a WORCS project folder (a project with a
\code{.worcs} file). Default: '.' (path to current directory).}

\item{verbose}{Logical. Whether or not to show status messages while
evaluating the checklist. Default: \code{TRUE}.}
}
\value{
A \code{data.frame} with a description of the criteria, and a column
with evaluations (\code{$pass}). For criteria that must be evaluated
manually, \code{$pass} will be \code{FALSE}.
}
\description{
Evaluates whether a project meets the criteria of the WORCS
checklist (see \code{\link{worcs_checklist}}).
}
\examples{
example_dir <- file.path(tempdir(), "badge")
dir.create(example_dir)
write("a", file.path(example_dir, ".worcs"))
check_worcs(path = example_dir)
}
