% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotWindfarmGA.R
\name{PlotWindfarmGA}
\alias{PlotWindfarmGA}
\title{Plot the results of an optimization run}
\usage{
PlotWindfarmGA(result, GridMethod = "r", Polygon1, whichPl = "all",
  best = 1, plotEn = 1, Projection, weibullsrc)
}
\arguments{
\item{result}{An output matrix of the function \code{\link{windfarmGA}} or
\code{\link{genAlgo}}, which has stored all relevant information. (matrix)}

\item{GridMethod}{Which grid spacing method was used. Default is
"rectangular". If hexagonal grid cells were used, assign any of the following
arguments: "h","hexa", "hexagonal". (character)}

\item{Polygon1}{The considered area as shapefile. Only required if the
shapefile is already loaded.(SpatialPolygons)}

\item{whichPl}{Which plots should be shown: 1-8 are possible. The default
is "all" which shows all available plots.}

\item{best}{A numeric value indicating how many of the best individuals
should be plotted. (numeric)}

\item{plotEn}{A numeric value that indicates if the best energy or
efficiency output should be plotted. If (plotEn==1) plots the best energy
solutions and (plotEn==2) plots the best efficiency solutions. (numeric)}

\item{Projection}{A desired Projection can be used instead
of the default Lambert Azimuthal Equal Area Projection. (character)}

\item{weibullsrc}{A list of Weibull parameter rasters, where the first list
item must be the shape parameter raster k and the second item must be the
scale parameter raster a of the Weibull distribution. If no list is given,
then rasters included in the package are used instead, which currently
only cover Austria. This variable is only used if weibull==TRUE. (list)}
}
\description{
Plot the results of a genetic algorithm run with given inputs.
Several plots try to show all relevant effects and outcomes of the
algorithm. 8 plot methods are available that can be selected individually.
}
\examples{
\donttest{
library(sp)
## Add some data examples from the package
load(file = system.file("extdata/resultrect.rda", package = "windfarmGA"))
load(file = system.file("extdata/resulthex.rda", package = "windfarmGA"))
load(file = system.file("extdata/polygon.rda", package = "windfarmGA"))

## Plot the results of a hexagonal grid optimization
result <- resulthex
Polygon1 <- polygon
PlotWindfarmGA(result, GridMethod = "h", Polygon1, whichPl = "all", best = 1, plotEn = 1)

## Plot the results of a rectangular grid optimization
result <- resultrect
Polygon1 <- polygon
PlotWindfarmGA(result, GridMethod = "r", Polygon1, whichPl = "all", best = 1, plotEn = 1)

## Plot the results with hexagonal grid cells and a weibull mean background.
a_param <- readRDS(system.file("extdata/a_weibull.RDS", package = "windfarmGA"))
k_param <- readRDS(system.file("extdata/k_weibull.RDS", package = "windfarmGA"))
weibullsrc <- list(k_param, a_param)
PlotWindfarmGA(result, GridMethod = "h", Polygon1, whichPl = "all",
               best = 1, plotEn = 1, weibullsrc = weibullsrc)
}
}
\author{
Sebastian Gatscha
}
