% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sf2ltraj.R
\name{sf2ltraj}
\alias{sf2ltraj}
\title{Convert sf spatial object to ltraj}
\usage{
sf2ltraj(sfp, date, id, cols = NULL)
}
\arguments{
\item{sfp}{an object of the class \code{sf} which contains the time-stamped movement fixes (as points) of the object(s).}

\item{date}{the name of the column containing the date-time information of each fix. Must be converted to a POSIXct type.}

\item{id}{either a character string indicating the identity of the animal or the name of the column with the ID of the individuals.}

\item{cols}{(optional) character vector specifiying the names of columns to keep as attributes (infolocs) in the ltraj object.}
}
\value{
A \code{ltraj} object. For more information on objects of this type see \code{help(ltraj)} and \code{?as.ltraj}.
}
\description{
The function \code{sf2ltraj} is a simple function for converting sf objects to ltraj objects.
}
\details{
The function \code{sf2ltraj} can be used to convert an \code{sf} object (stored as points) into an \code{ltraj} object.
}
\examples{
data(deer)
#points
deer_pt <- ltraj2sf(deer)
deer_tr <- sf2ltraj(deer_pt, date='date', id='id')

}
\seealso{
conSpatial, ltraj2sf
}
\keyword{processing}
