% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wikisource_book.R
\name{wikisource_book}
\alias{wikisource_book}
\title{Download a book from Wikisource}
\usage{
wikisource_book(url)
}
\arguments{
\item{url}{A url of a Wikisource content page listing the pages
constituting the book.}
}
\value{
A five column tbl_df (a type of data frame; see tibble or
dplyr packages) with one row for each line of the text or texts,
with columns.

\describe{
  \item{text}{A character column}
  \item{title}{A character column with the title of the Wikisource
  summary page}
  \item{page}{Integer column with a number for the text from each
  Wikisource page downloaded}
  \item{language}{A character column with a two letter string refering
  the language of the text}
  \item{url}{A character column with the url of the Wikisource page
  of the text}
}
}
\description{
Download a book using the url of a Wikisource content page into a
data frame. The Wikisource table of content page should link to all the
Wikisource pages constituting the book. The text in the Wikisource
pages is downloaded using the \code{wikisource_page()} function.
}
\details{
The download could fail if the Wikisource paths listed
into content page strongly differ from the url path of the content page.
}
\examples{

\dontrun{

# download Voltaire's "Candide"
wikisource_book("https://en.wikisource.org/wiki/Candide")

# download "Candide" in French and Spanish
library(purrr)

fr <- "https://fr.wikisource.org/wiki/Candide,_ou_l\%E2\%80\%99Optimisme/Garnier_1877"
de <- "https://es.wikisource.org/wiki/C\%C3\%A1ndido,_o_el_optimismo"
books <- map_df(c(fr, es), wikisource_book)
}

}
