% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro_analysis.R
\name{wbt_quinn_flow_accumulation}
\alias{wbt_quinn_flow_accumulation}
\title{Quinn flow accumulation}
\usage{
wbt_quinn_flow_accumulation(
  dem,
  output,
  out_type = "specific contributing area",
  exponent = 1,
  threshold = NULL,
  log = FALSE,
  clip = FALSE,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{dem}{Name of the input DEM raster file; must be depressionless.}

\item{output}{Name of the output raster file.}

\item{out_type}{Output type; one of 'cells', 'specific contributing area' (default), and 'catchment area'.}

\item{exponent}{Optional exponent parameter; default is 1.0.}

\item{threshold}{Optional convergence threshold parameter, in grid cells; default is infinity.}

\item{log}{Log-transform the output values?.}

\item{clip}{Optional flag to request clipping the display max by 1 percent.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Calculates Quinn et al. (1995) flow accumulation.
}
\keyword{HydrologicalAnalysis}
