% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/max.R
\name{vo2_max}
\alias{vo2_max}
\title{VO2max}
\usage{
vo2_max(
  .data,
  vo2_column = "VO2",
  vo2_relative_column = NULL,
  heart_rate_column = NULL,
  rer_column = NULL,
  detect_outliers = TRUE,
  average_method = c("bin", "rolling"),
  average_length = 30,
  mrt,
  plot = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{.data}{Data retrieved from \code{read_data()}.}

\item{vo2_column}{The name (quoted) of the column containing the absolute oxygen uptake (VO2) data. Default to \code{"VO2"}.}

\item{vo2_relative_column}{The name (quoted) of the column containing the relative to body weight oxygen uptake (VO2) data. Default to \code{NULL}.}

\item{heart_rate_column}{The name (quoted) of the column containing the heart rate (HR) data. Default to \code{NULL}. If \code{NULL}, this parameter will not be calculated.}

\item{rer_column}{The name (quoted) of the column containing the respiratory exchange ratio (RER) data. Default to \code{NULL}. If \code{NULL}, this parameter will not be calculated.}

\item{detect_outliers}{A boolean indicating whether to detect outliers. Default to \code{TRUE}.}

\item{average_method}{The average method to be used for VO2max calculation. One of \code{bin} or \code{rolling}.}

\item{average_length}{The length, in seconds, of the average to be used. For example, if \code{average_method = bin}, and \code{average_length = 30}, it will perform a 30-s bin-average.}

\item{mrt}{A boolean indicating whether to calculate the mean response time. To be implemented soon <-  currently ignored.}

\item{plot}{A boolean indicating whether to produce a plot with the summary results. Default to \code{TRUE}.}

\item{verbose}{A boolean indicating whether messages should be printed in the console. Default to \code{TRUE}.}

\item{...}{Additional arguments passed onto \code{incremental_normalize()}, \code{detect_outliers()} if \code{detect_outliers = TRUE}, and  \code{incremental_mrt()} if \code{mrt = TRUE}.}
}
\value{
a \link[tibble:tibble-package]{tibble} containing one row and the following columns:
\item{VO2max_absolute}{The absolute VO2max.}
\item{VO2max_relative}{The relative VO2max.}
\item{POpeak}{The peak power output.}
\item{HRmax}{The maximal heart rate.}
\item{RERmax}{The maximal RER.}
\item{plot}{The plot, if \code{plot = TRUE}.}
}
\description{
It performs the whole process of the VO2max data analysis, which includes:
data standardization and normalization according to incremental protocol (\code{incremental_normalize()}),
'bad breaths' detection (\code{detect_outliers()}),
mean response time calculation (\code{incremental_mrt()}) (currently ignored),
and maximal values calculation (VO2, PO, HR, RER) (\code{perform_max()}).
}
\details{
TODO
}
\examples{
\dontrun{
## get file path from example data
path_example <- system.file("ramp_cosmed.xlsx", package = "whippr")

## read data from ramp test
df <- read_data(path = path_example, metabolic_cart = "cosmed")

## normalize incremental test data
ramp_normalized <- df \%>\%
 incremental_normalize(
   .data = .,
   incremental_type = "ramp",
   has_baseline = TRUE,
   baseline_length = 240,
   work_rate_magic = TRUE,
   baseline_intensity = 20,
   ramp_increase = 25
 )

## detect outliers
data_ramp_outliers <- detect_outliers(
 .data = ramp_normalized,
 test_type = "incremental",
 vo2_column = "VO2",
 cleaning_level = 0.95,
 method_incremental = "linear",
 verbose = TRUE
)

## analyze VO2max
perform_max(
 .data = data_ramp_outliers,
 vo2_column = "VO2",
 vo2_relative_column = "VO2/Kg",
 heart_rate_column = "HR",
 rer_column = "R",
 average_method = "bin",
 average_length = 30,
 plot = TRUE,
 verbose = FALSE
)
}

}
