% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weightfunct.R
\name{weightfunct}
\alias{weightfunct}
\title{Estimate the Vevea and Hedges (1995) Weight-Function Model}
\usage{
weightfunct(effect, v, steps = c(0.05, 1), mods = NULL, weights = NULL,
  fe = FALSE, table = FALSE)
}
\arguments{
\item{effect}{a vector of meta-analytic effect sizes.}

\item{v}{a vector of meta-analytic sampling variances; needs to match up with the vector of effects, such that the first element in the vector of effect sizes goes with the first element in the vector of sampling variances, and so on.}

\item{steps}{a vector of p-value cutpoints. The default only distinguishes between significant and non-significant effects (p < 0.05).}

\item{mods}{defaults to \code{NULL}. A formula specifying the linear model.}

\item{weights}{defaults to \code{FALSE}. A vector of prespecified weights for p-value cutpoints to estimate the Vevea and Woods (2005) model.}

\item{fe}{defaults to \code{FALSE}. Indicates whether to estimate a fixed-effects model.}

\item{table}{defaults to \code{FALSE}. Indicates whether to print a table of the p-value intervals specified and the number of effect sizes per interval.}
}
\value{
The function returns a list containing the following components: \code{unadj_est}, \code{unadj_se}, \code{adj_est}, \code{adj_se}, \code{z_unadj}, \code{z_adj}, \code{p_unadj}, \code{p_adj}, \code{ci.lb_unadj}, \code{ci.ub_unadj}, \code{ci.lb_adj}, and \code{ci.ub_adj}.

For each component, the order of relevant parameters is as follows: variance component, mean or linear coefficients, and weights. (Note that if \code{weights}
are specified using the Vevea and Woods (2005) model, no standard errors, p-values, z-values, or confidence intervals
are provided for the adjusted model, as these are no longer meaningful. Also note that the variance component is not reported for fixed-effects models.)
\describe{
   \item{\code{unadj_est}}{the unadjusted model estimates}
   \item{\code{unadj_se}}{standard errors for unadjusted model estimates}
   \item{\code{adj_est}}{the adjusted model estimates}
   \item{\code{adj_se}}{standard errors for adjusted model estimates}
   \item{\code{z_unadj}}{z-statistics for the unadjusted model estimates}
   \item{\code{z_adj}}{z-statistics for the adjusted model estimates}
   \item{\code{p_unadj}}{p-values for the unadjusted model estimates}
   \item{\code{p_adj}}{p-values for the adjusted model estimates}
   \item{\code{ci.lb_unadj}}{lower bounds of the 95\% confidence intervals for the
   unadjusted model estimates}
   \item{\code{ci.ub_unadj}}{upper bounds of the 95\% confidence intervals for the
   unadjusted model estimates}
   \item{\code{ci.lb_adj}}{lower bounds of the 95\% confidence intervals for the
   adjusted model estimates}
   \item{\code{ci.ub_adj}}{upper bounds of the 95\% confidence intervals for the
   adjusted model estimates}
   }
}
\description{
This function allows the user to estimate the Vevea and Hedges (1995) weight-function model for publication bias.
}
\details{
This function allows meta-analysts to estimate both the
weight-function model for publication bias that was originally published in
Vevea and Hedges (1995) and the modified version presented in Vevea and Woods
(2005). Users can estimate both of these models with and without predictors and
in random-effects or fixed-effects situations.

The Vevea and Hedges (1995) weight-function model is a tool for modeling publication
bias using weighted distribution theory. The model first estimates an unadjusted
fixed-, random-, or mixed-effects model, where the observed effect sizes are
assumed to be normally distributed as a function of predictors. This unadjusted
model is no different from the traditional meta-analytic model. Next, the Vevea
and Hedges (1995) weight-function model estimates an adjusted model that includes
not only the original mean model, fixed-, random-, or mixed-effects, but a series
of weights for any pre-specified p-value intervals of interest. This produces mean,
variance component, and covariate estimates adjusted for publication bias, as well
as weights that reflect the likelihood of observing effect sizes in each specified
interval.

It is important to remember that the weight for each
estimated p-value interval must be interpreted relative to the first interval,
the weight for which is fixed to 1 so that the model is identified. In other
words, a weight of 2 for an interval indicates that effect sizes in that p-value
interval are about twice as likely to be observed as those in the first interval.
Finally, it is also important to remember that the model uses p-value cutpoints
corresponding to one-tailed p-values. This allows flexibility in the selection
function, which does not have to be symmetric for effects in the opposite direction;
a two-tailed p-value of 0.05 can therefore be represented as p < .025 or p > .975.

After both the unadjusted and adjusted meta-analytic models are estimated, a
likelihood-ratio test compares the two. The degrees of freedom for this test are
equal to the number of weights being estimated. If the likelihood-ratio test is
significant, this indicates that the adjusted model is a better fit for the data,
and that publication bias may be a concern.

To estimate a large number of weights for p-value intervals, the Vevea and Hedges
(1995) model works best with large meta-analytic datasets. It may have trouble
converging and yield unreliable parameter estimates if researchers, for instance,
specify a p-value interval that contains no observed effect sizes. However,
meta-analysts with small datasets are still likely to be interested in assessing
publication bias, and need tools for doing so. Vevea and Woods (2005)
attempted to solve this problem by adapting the Vevea and Hedges (1995) model to
estimate fewer parameters. The meta-analyst can specify p-value cutpoints,
as before, and specify corresponding fixed weights for those cutpoints. Then the
model is estimated. For the adjusted model, only the variance component and mean
model parameters are estimated, and they are adjusted relative to the fixed weights.
For example, weights of 1 for each p-value interval specified describes a situation
where there is absolutely no publication bias, in which the adjusted estimates are
identical to the unadjusted estimates. By specifying weights that depart from 1 over various p-value intervals, meta-analysts can
examine how various one-tailed or two-tailed selection patterns would alter their
effect size estimates. If changing the pattern of weights drastically changes
the estimated mean, this is evidence that the data may be vulnerable to
publication bias.

For more information, consult the papers listed in the References section here.
Also, feel free to email the maintainer of \code{weightr} at kcoburn@ucmerced.edu.
The authors are currently at work on a detailed package tutorial, which we
hope to publish soon.
}
\examples{
\dontrun{
# Uses the default p-value cutpoints of 0.05 and 1:

weightfunct(effect, v)

# Estimating a fixed-effects model, again with the default cutpoints:

weightfunct(effect, v, fe=TRUE)

# Specifying cutpoints:

weightfunct(effect, v, steps=c(0.01, 0.025, 0.05, 0.10, 0.20, 0.30, 0.50, 1.00))

# Including a linear model, where moderators are denoted as 'mod1' and mod2':

weightfunct(effect, v, mods=~mod1+mod2)

# Specifying cutpoints and weights to estimate Vevea and Woods (2005):

weightfunct(effect, v, steps=c(0.01, 0.05, 0.50, 1.00), weights=c(1, .9, .7, .5))

# Specifying cutpoints and weights while including a linear model:

weightfunct(effect, v, mods=~mod1+mod2, steps=c(0.05, 0.10, 0.50, 1.00), weights=c(1, .9, .8, .5))
}
}
\references{
Coburn, K. M. & Vevea, J. L. (2015). Publication bias as a function
of study characteristics. Psychological Methods, 20(3), 310.

Vevea, J. L. & Hedges, L. V. (1995). A general linear model for
estimating effect size in the presence of publication bias. Psychometrika, 60(3),
419-435.

Vevea, J. L. & Woods, C. M. (2005). Publication bias in research synthesis:
Sensitivity analysis using a priori weight functions. Psychological Methods, 10(4),
428-443.
}
\keyword{weightr}

