% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_stats_player.R
\name{wnba_playergamelog}
\alias{wnba_playergamelog}
\title{\strong{Get WNBA Stats API Player Game Log}}
\usage{
wnba_playergamelog(
  date_from = "",
  date_to = "",
  league_id = "10",
  player_id = "1628932",
  season = most_recent_wnba_season() - 1,
  season_type = "Regular Season",
  ...
)
}
\arguments{
\item{date_from}{date_from}

\item{date_to}{date_to}

\item{league_id}{League - default: '00'. Other options include '10': WWNBA, '20': G-League}

\item{player_id}{Player ID}

\item{season}{Season - format 2020-21}

\item{season_type}{Season Type - Regular Season, Playoffs, All-Star}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: PlayerGameLog

\strong{PlayerGameLog}\tabular{ll}{
   col_name \tab types \cr
   SEASON_ID \tab character \cr
   Player_ID \tab character \cr
   Game_ID \tab character \cr
   GAME_DATE \tab character \cr
   MATCHUP \tab character \cr
   WL \tab character \cr
   MIN \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   TOV \tab character \cr
   PF \tab character \cr
   PTS \tab character \cr
   PLUS_MINUS \tab character \cr
   VIDEO_AVAILABLE \tab character \cr
}
}
\description{
\strong{Get WNBA Stats API Player Game Log}

\strong{Get WNBA Stats API Player Game Log}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{  wnba_playergamelog(player_id = '1628932')
}\if{html}{\out{</div>}}
}
\seealso{
Other WNBA Player Functions: 
\code{\link{wnba_infographicfanduelplayer}()},
\code{\link{wnba_leaguedashplayerbiostats}()},
\code{\link{wnba_leaguedashplayerclutch}()},
\code{\link{wnba_leaguedashplayershotlocations}()},
\code{\link{wnba_leaguedashplayerstats}()},
\code{\link{wnba_leagueplayerondetails}()},
\code{\link{wnba_leagueseasonmatchups}()},
\code{\link{wnba_playerawards}()},
\code{\link{wnba_playercareerbycollegerollup}()},
\code{\link{wnba_playercareerbycollege}()},
\code{\link{wnba_playercareerstats}()},
\code{\link{wnba_playercompare}()},
\code{\link{wnba_playerdashboardbyclutch}()},
\code{\link{wnba_playerdashboardbygamesplits}()},
\code{\link{wnba_playerdashboardbygeneralsplits}()},
\code{\link{wnba_playerdashboardbylastngames}()},
\code{\link{wnba_playerdashboardbyopponent}()},
\code{\link{wnba_playerdashboardbyshootingsplits}()},
\code{\link{wnba_playerdashboardbyteamperformance}()},
\code{\link{wnba_playerdashboardbyyearoveryear}()},
\code{\link{wnba_playerestimatedmetrics}()},
\code{\link{wnba_playerfantasyprofilebargraph}()},
\code{\link{wnba_playerfantasyprofile}()},
\code{\link{wnba_playergamelogs}()},
\code{\link{wnba_playergamestreakfinder}()},
\code{\link{wnba_playerheadshot}()},
\code{\link{wnba_playerindex}()},
\code{\link{wnba_playernextngames}()},
\code{\link{wnba_playerprofilev2}()},
\code{\link{wnba_playervsplayer}()}
}
\author{
Saiem Gilani
}
\concept{WNBA Player Functions}
