% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{sum_activity}
\alias{sum_activity}
\title{Summarize activity per person}
\usage{
sum_activity(wt, timeframe = "date")
}
\arguments{
\item{wt}{webtrack data object.}

\item{timeframe}{character. Indicates for what time frame to aggregate visits.
Possible values are \code{"date"}, \code{"week"}, \code{"month"}, \code{"year"} or \code{"wave"}. If
set to \code{"wave"}, \code{wt} must contain a column call \code{wave}. Defaults to \code{"date"}.}
}
\value{
a data.table with columns \code{panelist_id}, column indicating the
number of active time units.
}
\description{
\code{sum_activity()} counts the number of active time periods (i.e., days, weeks,
months, years, or waves) by \code{panelist_id}. A period counts as "active" if
the panelist provided at least one visit for that period.
}
\examples{
\dontrun{
data("testdt_tracking")
wt <- as.wt_dt(testdt_tracking)
# summarize activity by day
wt_sum <- sum_activity(wt, timeframe = "date")
}
}
