% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delin.R
\name{delin}
\alias{delin}
\title{Manually delineate images}
\usage{
delin(stimuli)
}
\arguments{
\item{stimuli}{list of stimuli}
}
\value{
list of stimuli with new templates
}
\description{
Adjust the templates in a shiny interface. This will overwrite existing templates.
}
\examples{
if (interactive()) {
# adjust existing delineations
stimuli <- demo_stim() |> delin()

# create new delineations from scratch
stimuli <- demo_stim() |> remove_tems() |> delin()
}
}
\seealso{
Template functions
\code{\link{auto_delin}()},
\code{\link{average_tem}()},
\code{\link{centroid}()},
\code{\link{change_lines}()},
\code{\link{draw_tem}()},
\code{\link{features}()},
\code{\link{get_point}()},
\code{\link{remove_tem}()},
\code{\link{require_tems}()},
\code{\link{same_tems}()},
\code{\link{squash_tem}()},
\code{\link{subset_tem}()},
\code{\link{tem_def}()},
\code{\link{viz_tem_def}()}
}
\concept{tem}
