% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StubRegistry.R
\docType{data}
\name{StubRegistry}
\alias{StubRegistry}
\title{Stub registry}
\description{
Stub registry
}
\details{
\strong{Methods}
\describe{
\item{\code{register_stub(stub)}}{
Register a stub
- stub: an object of class \link{StubbedRequest}
}
\item{\code{find_stubbed_request(req)}}{
Find a stubbed request
- req: an object of class \link{RequestSignature}
}
\item{\code{response_for_request(request_signature)}}{
Find a stubbed request
- request_signature: an object of class \link{RequestSignature}
}
\item{\code{request_stub_for(request_signature)}}{
Find a stubbed request
- request_signature: an object of class \link{RequestSignature}
}
\item{\code{remove_request_stub(stub)}}{
Remove a stubbed request by matching request signature
- stub: an object of class \link{StubbedRequest}
}
\item{\code{remove_all_request_stubs()}}{
Remove all request stubs
}
\item{\code{is_registered(x)}}{
Find a stubbed request
- x: an object of class \link{RequestSignature}
}
}
}
\examples{
\dontrun{
# Make a stub
stub1 <- StubbedRequest$new(method = "get", uri = "api.crossref.org")
stub1$with(headers = list('User-Agent' = 'R'))
stub1$to_return(status = 200, body = "foobar", headers = list())
stub1

# Make another stub
stub2 <- StubbedRequest$new(method = "get", uri = "api.crossref.org")
stub2

# Put both stubs in the stub registry
reg <- StubRegistry$new()
reg$register_stub(stub = stub1)
reg$register_stub(stub = stub2)
reg
reg$request_stubs
}
}
\seealso{
Other stub-registry: \code{\link{remove_request_stub}},
  \code{\link{stub_registry_clear}},
  \code{\link{stub_registry}}
}
\concept{stub-registry}
\keyword{datasets}
