% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webdeveloper.R
\name{serveHTTP}
\alias{serveHTTP}
\title{Conveniently create HTTP server using httpuv::startServer() or httpuv::runServer().}
\usage{
serveHTTP(
  host = "127.0.0.1",
  port = 5001,
  persistent = FALSE,
  static = list(),
  dynamic = list()
)
}
\arguments{
\item{host}{A string that is a valid IPv4 or IPv6 address that is owned by this server, which the application will listen on.
"0.0.0.0" represents all IPv4 addresses and "::/0" represents all IPv6 addresses. Refer to host parameter of httpuv::startServer() for more details.}

\item{port}{The port number to listen on. Refer to port parameter of httpuv::startServer() for more details.}

\item{persistent}{TRUE/FALSE. If FALSE, calls httpuv::startServer(), which returns back to the R session
(and would therefore not work with launching a persistent server through a system service as the R session would continue and likely exit/end).
If TRUE, calls httpuv::runServer(), which does not return to the R session unless an error or
interruption occurs and is suitable for use with system services to start or stop a server.}

\item{static}{A named list, names should be URL paths, values should be paths to the files to be served statically
(such as a HTML file saved somewhere).}

\item{dynamic}{A named list, names should be URL paths, values should be named vectors with vector names equaling a
HTTP method (such as "GET" or "POST") and the values being expressions that when evaluated return a named list with valid entries
for status, headers, and body as specified by httpuv::startServer(). Refer to httpuv::startServer() for more details on what can be returned
as the response.
ex. list("/" = c("GET" = expression(get_function(req)), "POST" = expresssion(post_function(req))))}
}
\value{
A HTTP web server on the specified host and port.
}
\description{
Conveniently create HTTP server using httpuv::startServer() or httpuv::runServer().
}
\details{
serveHTTP is a convenient way to start a HTTP server that works for both static and dynamically created pages.
It offers a simplified and organized interface to httpuv::startServer()/httpuv::runServer() that makes serving static and
dynamic pages easier. For dynamic pages, the expression evaluated when a browser requests a dynamically served path should
likely be an expression wrapping a function that has "req" as a parameter. Per the Rook specification implemented by httpuv, "req" is
the R environment in which browser request information is collected. Therefore, to access HTTP request headers, inputs, etc. in a function
served by a dynamic path, "req" should be a parameter of that function. For the dynamic parameter of serveHTTP,
list("/" = c("GET" = expression(get_homepage(req)))) would be a suitable way to call the function get_homepage(req) when the root path of a
website is requested with the GET method. The req environment has the following variables:
request_method = req$REQUEST_METHOD,
script_name = req$SCRIPT_NAME,
path_info = req$PATH_INFO,
query_string = req$QUERY_STRING,
server_name = req$SERVER_NAME,
server_port = req$SERVER_PORT,
headers = req$HEADERS,
rook_input = req[["rook.input"]]$read_lines(),
rook_version = req[["rook.version"]]$read_lines(),
rook_url_scheme = req[["rook.url_scheme"]]$read_lines(),
rook_error_stream = req[["rook.errors"]]$read_lines()
}
\examples{
# Run both functions and go to http://127.0.0.1:5001/ in a web browser
get_example <- function(req){

html <- html_doc(
head(),
body(
h1("Hello"),
p("Here is a list of some of the variables included in the req environment
that were associated with this request:"),
ul(
li(paste0("req$REQUEST_METHOD = ", req$REQUEST_METHOD)),
li(paste0("req$SCRIPT_NAME = ", req$SCRIPT_NAME)),
li(paste0("req$PATH_INFO = ", req$PATH_INFO)),
li(paste0("req$QUERY_STRING = ", req$QUERY_STRING)),
li(paste0("req$SERVER_NAME = ", req$SERVER_NAME)),
li(paste0("req$SERVER_PORT = ", req$SERVER_PORT))
),
p("You can use paramList() to deal with inputs passed through query strings as
well as passed through the input stream."),
p("params <- paramList(req[[\"rook.input\"]]$read_lines()) will give you a
named list of parameters.")
)
)
return(
list(
status = 200L,
headers = list('Content-Type' = 'text/html'),
body = html
)
)
}

serveHTTP(
host = "127.0.0.1",
port = 5001,
persistent = FALSE,
static = list(),
dynamic = list(
"/" = c(
"GET" = expression(get_example(req))
)
)
)
}
