% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chembl.R
\name{chembl_query}
\alias{chembl_query}
\title{Query ChEMBL using ChEMBL IDs}
\usage{
chembl_query(
  query,
  resource = "molecule",
  cache_file = NULL,
  verbose = getOption("verbose"),
  test_service_down = FALSE
)
}
\arguments{
\item{query}{character; a vector of ChEMBL IDs.}

\item{resource}{character; the ChEMBL resource to query. Use
[chembl_resources()] to see all available resources.}

\item{cache_file}{character; the name of the cache file without the file
extension. If \code{NULL}, results are not cached.}

\item{verbose}{logical; should a verbose output be printed on the console?}

\item{test_service_down}{logical; this argument is only used for testing.}
}
\value{
The function returns a list of lists, where each element of the list
contains a list of respective query results. Results are simplified, if
possible.
}
\description{
Retrieve ChEMBL data using a vector of ChEMBL IDs.
}
\details{
Each entry in ChEMBL has a unique ID. Data in ChEMBL is organized in
databases called resources. An entry may or may not have a record in a
particular resource. An entry may have a record in more than one resource,
e.g. a compound may be present in both the "molecule" and the "drug"
resource. This function queries a vector of ChEMBL IDs from a specific ChEMBL
resource.

If you are unsure which ChEMBL resource contains your ChEMBL ID,
use this function with the \code{"chembl_id_lookup"} resource to find the
appropriate resource for a ChEMBL ID. Note that \code{"chembl_id_lookup"} is
not a separate function but a resource used by \code{chembl_query}.

If \code{cache_file} is not \code{NULL} the function creates a
cache directory in the working directory and a cache file in the cache
directory. This file is used in subsequent calls of the function. The
function first tries to retrieve query results from the cache file and only
accesses the webservice if the ChEMBL ID cannot be found in the cache file.
The cache file is extended as new ChEMBL ID-s are queried during the session.
}
\note{
Links to the webservice documentation:
\itemize{
     \item \url{https://chembl.gitbook.io/chembl-interface-documentation},
     \item \url{https://www.ebi.ac.uk/chembl/api/data/docs}
}
}
\examples{
\dontrun{
# Might fail if API is not available

# Search molecules
chembl_query("CHEMBL1082", resource = "molecule")
chembl_query(c("CHEMBL25", "CHEMBL1082"), resource = "molecule")

# Look up ChEMBL IDs in ChEMBL "resources", returns one resource per query.
chembl_query("CHEMBL771355", "chembl_id_lookup")

# Search assays
chembl_query("CHEMBL771355", resource = "assay")
}
}
\references{
Gaulton, A., Bellis, L. J., Bento, A. P., Chambers, J.,
Davies, M., Hersey, A., ... & Overington, J. P. (2012). ChEMBL: a large-scale
bioactivity database for drug discovery. Nucleic acids research, 40(D1),
D1100-D1107.
}
