% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pubchem.R
\name{get_pcid}
\alias{get_pcid}
\title{Retrieve Pubchem Id (CID)}
\usage{
get_pcid(query, first = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{query}{charachter; search term.}

\item{first}{logical; If TRUE return only first result.}

\item{verbose}{logical; should a verbose output be printed on the console?}

\item{...}{currently not used.}
}
\value{
a character vector.
}
\description{
Return CompoundID (CID) for a search query, see \url{https://pubchem.ncbi.nlm.nih.gov/}.
}
\examples{
\donttest{
# might fail if API is not available
get_pcid('Triclosan')

# multiple inputs
comp <- c('Triclosan', 'Aspirin')
sapply(comp, function(x) get_pcid(x))
sapply(comp, function(x) get_pcid(x, first = TRUE))
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}
\references{
Wang, Y., J. Xiao, T. O. Suzek, et al. 2009 PubChem: A Public Information System for
Analyzing Bioactivities of Small Molecules. Nucleic Acids Research 37: 623–633.

Kim, Sunghwan, Paul A. Thiessen, Evan E. Bolton, et al. 2016
PubChem Substance and Compound Databases. Nucleic Acids Research 44(D1): D1202–D1213.
}

