% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.SDMfit.R
\name{predict.SDMfit}
\alias{predict.SDMfit}
\title{Predicts with a local model}
\usage{
\method{predict}{SDMfit}(object, newdata, pred_samples = NULL, prob.cov = TRUE, ...)
}
\arguments{
\item{object}{A SDMfit object, typically obtained with trophicSDM() and available in the field $model of a trophicSDMfit object}

\item{newdata}{A matrix containing both environmental covariates and the biotic variables that the local model uses to predict the species distribution.}

\item{pred_samples}{Number of samples to draw from species posterior predictive distribution when method = "stan_glm". If NULL, set by the default to the number of iterations/10.}

\item{prob.cov}{Only for presence-absence data. If set to FALSE, it gives back also predicted presence-absences (which is then used by trophicSDM.predict to predict the predators).}

\item{...}{additional arguments}
}
\value{
A list containing for each species the predicted value at each sites. If method = "stan_glm", then each element of the list is a sites x pred_samples matrix containing the posterior predictive distribution of the species at each sites. If prob.cov = TRUE, it returns a list containing:
\itemize{
\item{predictions.prob}{Predicted probabilities of presence}
\item{predictions.prob}{Predicted presence-absences}
}
}
\description{
Computes predicted values for a local model, i.e., a fitted SDMfit object This is sequentially called, for each species, by the function trophicSDM.predict
}
\examples{
data(Y, X, G)
# define abiotic part of the model
env.formula = "~ X_1 + X_2"
# Run the model with bottom-up control using stan_glm as fitting method and no penalisation
# (set iter = 1000 to obtain reliable results)
m = trophicSDM(Y, X, G, env.formula, iter = 100,
               family = binomial(link = "logit"), penal = NULL, 
               mode = "prey", method = "stan_glm")
# In order to predict non-basal species, we need to also provide
# the predicted occurrences of its preys. Here we compute the probability of
# presence of species Y4 at environemntal conditions c(0.5,0.5)
# when its prey Y3 is present.
predict(m$model$Y4, newdata = data.frame(X_1 = 0.5, X_2 = 0.5, Y3 = 1), pred_samples = 10)
}
\author{
Giovanni Poggiato and Jérémy Andréoletti
}
