## ---- include = FALSE-----------------------------------------------------------------------------------------------------------------------------------------
knitr::opts_chunk$set(cache = FALSE)
old <- options(width = 160)

## ---- message = FALSE-----------------------------------------------------------------------------------------------------------------------------------------
library(dplyr)
library(ggplot2)
library(weathercan)

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
head(stations())
glimpse(stations())

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
stations_search("Kamloops")

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
stations_search("Kamloops", interval = "hour")

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
stations_search("Kamloops", interval = c("hour", "month"))

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
stations_search(coords = c(50.667492, -120.329049), dist = 20, interval = "hour")

## ----search_crit----------------------------------------------------------------------------------------------------------------------------------------------
BCstations <- stations() %>%
  filter(prov %in% c("BC")) %>%
  filter(interval == "hour") %>%
  filter(lat > 49 & lat < 49.5) %>%
  filter(lon > -119 & lon < -116) %>%
  filter(start <= 2002) %>%
  filter(end >= 2016)
BCstations

## weather_dl() accepts numbers so we can create a vector to input into weather:
stn_vector <- BCstations$station_id 
stn_vector

## ---- eval = FALSE--------------------------------------------------------------------------------------------------------------------------------------------
#  stations_dl()

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
stations_meta()

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
kam <- weather_dl(station_ids = 51423, start = "2016-01-01", end = "2016-02-15")
kam

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
kam.pg <- weather_dl(station_ids = c(48248, 51423), start = "2016-01-01", end = "2016-02-15")
                    
kam.pg

## ---- fig.height=6, fig.width=12------------------------------------------------------------------------------------------------------------------------------
ggplot(data = kam.pg, aes(x = time, y = temp, group = station_name, colour = station_name)) +
  theme(legend.position = "top") +
  geom_line() +
  theme_minimal()

## ----vector_input---------------------------------------------------------------------------------------------------------------------------------------------
stn_vec_df <- weather_dl(station_ids = stn_vector, start = "2016-01-01", end = "2016-02-15")

stn_vec_df

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
stations_search("Winnipeg", normals_years = "current")

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
stations_search("Winnipeg", normals_years = "1971-2000")

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
n <- normals_dl("5023222")

## ---- message = FALSE-----------------------------------------------------------------------------------------------------------------------------------------
library(tidyr)
unnest(n, normals)
unnest(n, frost)

## -------------------------------------------------------------------------------------------------------------------------------------------------------------
n <- normals_dl("5023222", normals_years = "1971-2000")
unnest(n, normals)
unnest(n, frost)

## ---- include = FALSE---------------------------------------------------------
# Reset options
options(old)

