% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/balancedaccuracy.R
\name{balancedaccuracy}
\alias{balancedaccuracy}
\title{Starovoitov-Golub Sine-Accuracy Function for Imbalanced Classification Data}
\usage{
balancedaccuracy(m, print.scores = TRUE)
}
\arguments{
\item{m}{the caret confusion matrix object or simple matrix.}

\item{print.scores}{print the accuracy metrics.}
}
\value{
a list containing 5 elements: 3 overall and 2 class accuracy scores
}
\description{
This function calculates classification accuracy scores using the sine-based
formulas proposed by Starovoitov and Golub (2020). The advantage of the new
method consists in producing improved results when compared with the standard
balanced accuracy function, by taking into account the class distribution of
errors.
}
\details{
The input object "m" should be a square matrix of at least size 2x2.
}
\examples{
m = matrix(c(70,0,0,10,10,0,5,3,2), ncol = 3, nrow=3)
balancedaccuracy(m, print.scores = TRUE)

}
\seealso{
[wconfusionmatrix()]
}
\author{
Alexandru Monahov, <https://www.alexandrumonahov.eu.org/>
}
\keyword{accuracy}
\keyword{balanced}
\keyword{metric}
\keyword{score}
\keyword{sine}
