% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local_getis.R
\name{ww_local_getis_ord_g}
\alias{ww_local_getis_ord_g}
\alias{ww_local_getis_ord_g_vec}
\alias{ww_local_getis_ord_g_pvalue}
\alias{ww_local_getis_ord_g_pvalue_vec}
\title{Local Getis-Ord G and G* statistic}
\usage{
ww_local_getis_ord_g(data, ...)

ww_local_getis_ord_g_vec(truth, estimate, wt, na_rm = FALSE, ...)

ww_local_getis_ord_g_pvalue(data, ...)

ww_local_getis_ord_g_pvalue_vec(truth, estimate, wt, na_rm = FALSE, ...)
}
\arguments{
\item{data}{A \code{data.frame} containing the columns specified by the \code{truth}
and \code{estimate} arguments.}

\item{...}{Additional arguments passed to \code{\link[spdep:localG]{spdep::localG()}} (for
\code{ww_local_getis_ord_g()}) or \code{\link[spdep:localG]{spdep::localG_perm()}} (for
\code{ww_local_getis_ord_pvalue()}).}

\item{truth}{The column identifier for the true results
(that is \code{numeric}). This should be an unquoted column name although
this argument is passed by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote column
names). For \verb{_vec()} functions, a \code{numeric} vector.}

\item{estimate}{The column identifier for the predicted
results (that is also \code{numeric}). As with \code{truth} this can be
specified different ways but the primary method is to use an
unquoted variable name. For \verb{_vec()} functions, a \code{numeric} vector.}

\item{wt}{A \code{listw} object, for instance as created with \code{\link[=ww_build_weights]{ww_build_weights()}}.
For data.frame input, may also be a function that takes \code{data} and returns a
\code{listw} object.}

\item{na_rm}{A \code{logical} value indicating whether \code{NA}
values should be stripped before the computation proceeds.}
}
\value{
A tibble with columns .metric, .estimator, and .estimate and \code{nrow(data)}
rows of values.
For \verb{_vec()} functions, a numeric vector of \code{length(truth)} (or NA).
}
\description{
Calculate the local Getis-Ord G and G* statistic for model residuals.
\code{ww_local_getis_ord_g()} returns the statistic itself, while
\code{ww_local_getis_ord_pvalue()} returns the associated p value.
These functions are meant to help assess model predictions, for instance by
identifying clusters of higher residuals than expected. For statistical
testing and inference applications, use \code{\link[spdep:localG]{spdep::localG_perm()}} instead.
}
\details{
These functions can be used for geographic or projected coordinate reference
systems and expect 2D data.
}
\examples{
guerry_model <- guerry
guerry_lm <- lm(Crm_prs ~ Litercy, guerry_model)
guerry_model$predictions <- predict(guerry_lm, guerry_model)

ww_local_getis_ord_g(guerry_model, Crm_prs, predictions)
ww_local_getis_ord_g_pvalue(guerry_model, Crm_prs, predictions)

wt <- ww_build_weights(guerry_model)

ww_local_getis_ord_g_vec(
  guerry_model$Crm_prs,
  guerry_model$predictions,
  wt = wt
)
ww_local_getis_ord_g_pvalue_vec(
  guerry_model$Crm_prs,
  guerry_model$predictions,
  wt = wt
)

}
\references{
Ord, J. K. and Getis, A. 1995. Local spatial autocorrelation statistics:
distributional issues and an application. Geographical Analysis, 27, 286–306.
doi: 10.1111/j.1538-4632.1995.tb00912.x
}
\seealso{
Other autocorrelation metrics: 
\code{\link{ww_global_geary_c}()},
\code{\link{ww_global_moran_i}()},
\code{\link{ww_local_geary_c}()},
\code{\link{ww_local_moran_i}()}

Other yardstick metrics: 
\code{\link{ww_agreement_coefficient}()},
\code{\link{ww_global_geary_c}()},
\code{\link{ww_global_moran_i}()},
\code{\link{ww_local_geary_c}()},
\code{\link{ww_local_moran_i}()},
\code{\link{ww_willmott_d}()}
}
\concept{autocorrelation metrics}
\concept{yardstick metrics}
