% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/full_spectrograms.R
\name{full_spectrograms}
\alias{full_spectrograms}
\title{Create long spectrograms of whole sound files}
\usage{
full_spectrograms(X = NULL, flim = c(0,22), sxrow = 5, rows = 10, 
collevels = seq(-40, 0, 1), ovlp = 50, parallel = 1, wl = 512, gr = FALSE, 
pal = reverse.gray.colors.2, cex = 1, it = "jpeg", flist = NULL, 
overwrite = TRUE, path = NULL, pb = TRUE, fast.spec = FALSE, labels = "selec",
 horizontal = FALSE, song = NULL, suffix = NULL, ...)
}
\arguments{
\item{X}{'selection_table' object or any data frame with columns
for sound file name (sound.files), selection number (selec), and start and end time of signal
(start and end). If given, a transparent box is  plotted around each selection and the selections are labeled with the selection number 
(and selection comment, if available). Default is \code{NULL}.Alternatively, it can also take the output of \code{\link{cross_correlation}} or \code{\link{auto_detec}} (when 'output' is a 'list', see \code{\link{cross_correlation}} or \code{\link{auto_detec}}). If supplied a secondary row is displayed under each spectrogram showing the detection (either cross-correlation scores or wave envelopes) values across time.}

\item{flim}{A numeric vector of length 2 indicating the highest and lowest 
frequency limits (kHz) of the spectrogram, as in 
\code{\link[seewave]{spectro}}. Default is c(0,22).}

\item{sxrow}{A numeric vector of length 1. Specifies seconds of spectrogram
per row. Default is 5.}

\item{rows}{A numeric vector of length 1. Specifies number of rows per 
image file. Default is 10.}

\item{collevels}{A numeric vector of length 3. Specifies levels to partition the 
amplitude range of the spectrogram (in dB). The more levels the higher the
resolution of the spectrogram. Default is seq(-40, 0, 1).}

\item{ovlp}{Numeric vector of length 1 specifying \% of overlap between two 
consecutive windows, as in \code{\link[seewave]{spectro}}. Default is 50. High values of ovlp 
slow down the function but produce more accurate selection limits (when X is provided).}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{wl}{A numeric vector of length 1 specifying the window length of the spectrogram, default 
is 512.}

\item{gr}{Logical argument to add grid to spectrogram. Default is \code{FALSE}.}

\item{pal}{Color palette function for spectrogram. Default is reverse.gray.colors.2. See 
\code{\link[seewave]{spectro}} for more palettes.}

\item{cex}{A numeric vector of length 1 giving the amount by which text 
(including sound file and page number) should be magnified. Default is 1.}

\item{it}{A character vector of length 1 giving the image type to be used. Currently only
"tiff" and "jpeg" are admitted. Default is "jpeg".}

\item{flist}{character vector or factor indicating the subset of files that will be analyzed. Ignored
if X is provided.}

\item{overwrite}{Logical argument. If \code{TRUE} all selections will be analyzed again 
when code is rerun. If \code{FALSE} only the selections that do not have a image 
file in the working directory will be analyzed. Default is \code{FALSE}.}

\item{path}{Character string containing the directory path where the sound files are located. 
If \code{NULL} (default) then the current working directory is used.}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}

\item{fast.spec}{Logical. If \code{TRUE} then image function is used internally to create spectrograms, which substantially 
increases performance (much faster), although some options become unavailable, as collevels, and sc (amplitude scale).
This option is indicated for signals with high background noise levels. Palette colors \code{\link[monitoR:specCols]{gray.1}}, \code{\link[monitoR:specCols]{gray.2}}, 
\code{\link[monitoR:specCols]{gray.3}}, \code{\link[monitoR:specCols]{topo.1}} and \code{\link[monitoR:specCols]{rainbow.1}} (which should be imported from the package monitoR) seem
to work better with 'fast' spectrograms. Palette colors \code{\link[monitoR:specCols]{gray.1}}, \code{\link[monitoR:specCols]{gray.2}}, 
\code{\link[monitoR:specCols]{gray.3}} offer 
decreasing darkness levels.}

\item{labels}{Character string with the name of the column(s) for selection 
labeling. Default is 'selec'. Set to \code{NULL} to remove labels.}

\item{horizontal}{Logical. Controls if the images are produced as horizontal or vertical pages. Default is \code{FALSE}.}

\item{song}{Character string with the name of the column to used as a label a for higher 
organization level in the song (similar to 'song_colm' in \code{\link{song_analysis}}). If supplied then lines above the selections belonging to the same
'song' are plotted. Ignored if 'X' is not provided.}

\item{suffix}{Character vector of length 1. Suffix for the output image file (to be added at the end of the default file name). Default is \code{NULL}.}

\item{...}{Additional arguments for image formatting. It accepts 'width', 'height' (which will overwrite 'horizontal') and 'res' as in \code{\link[grDevices]{png}}.}
}
\value{
image files with spectrograms of whole sound files in the working directory. Multiple pages
can be returned, depending on the length of each sound file.
}
\description{
\code{full_spectrograms} produces image files with spectrograms of whole sound files split into multiple 
  rows.
}
\details{
The function creates spectrograms for complete sound files, printing
  the name of the sound files and the "page" number (p1-p2...) at the upper 
  right corner of the image files. If 'X' is
  supplied, the function delimits and labels the selections. 
  This function aims to facilitate visual inspection of multiple files as well as visual classification 
  of vocalization units and the analysis of animal vocal sequences.
}
\examples{
\dontrun{
# save sound file examples to temporary working directory
data(list = c("Phae.long1", "Phae.long2","lbh_selec_table"))
writeWave(Phae.long1, file.path(tempdir(), "Phae.long1.wav")) 
writeWave(Phae.long2, file.path(tempdir(), "Phae.long2.wav"))

full_spectrograms(sxrow = 2, rows = 8, pal = reverse.heat.colors, wl = 300, 
path = tempdir())

# including selections
full_spectrograms(sxrow = 2, rows = 8, X = lbh_selec_table, 
pal = reverse.heat.colors, overwrite = TRUE, wl = 300, path = tempdir())

#check this floder
# tempdir()
}

}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\seealso{
\code{\link{full_spectrogram2pdf}}, \code{\link{catalog2pdf}}, \code{\link{cross_correlation}}, \code{\link{auto_detec}}
\href{https://marce10.github.io/2017/01/07/Create_pdf_files_with_spectrograms_of_full_recordings.html}{blog post on spectrogram pdfs}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
