% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mp32wav.R
\name{mp32wav}
\alias{mp32wav}
\title{Convert .mp3 files to .wav}
\usage{
mp32wav(samp.rate = 44.1, parallel = 1)
}
\arguments{
\item{samp.rate}{Sampling rate at which the .wav files should be written. The maximum permitted is 44.1 kHz (default). Units should be kHz.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (e.i. no parallel computing).
 For windows OS the \code{warbleR} from github to run parallel.}
}
\value{
.wav files saved in the working directory with same name as original mp3 files.
}
\description{
\code{mp32wav} converts several .mp3 files in working directory to .wav format
}
\details{
convert all .mp3 files in working directory to .wav format. Function used internally to read .mp3 files (\code{\link[tuneR]{readMP3}}) sometimes crashes.
}
\examples{
\dontrun{
# First set temporary folder
setwd(tempdir())
 
#Then download mp3 files from xeno-canto
querxc(qword = "Phaethornis aethopygus", download = TRUE)

# Convert all files to .wav format
mp32wav()

#check this folder!!
getwd()
}
}
\author{
Marcelo Araya-Salas (\email{araya-salas@cornell.edu}) and Grace Smith Vidaurre
}

