### **Module:** ***EcoClimate***

**BACKGROUND**

The ecoClimate project (<a href="www.ecoclimate.org" target="_blank">www.ecoclimate.org</a>) provides an open database of processed climatic simulations in a user-friendly format and at a resolution suitable for macroecological and biogeographic studies (Lima-Ribeiro et al. 2015; Varela et al. 2015). Monthly simulations of precipitation as well as mean, maximum, and minimum temperature for various time periods and coupled atmosphere-ocean global climate/circulation models (AOGCMs) were downloaded from the CMIP5 and PMIP3 projects. For ecoClimate, all data were downscaled to 0.5° resolution, according to the standard change-factor approach (Wilby et al. 2004). The 19 bioclimatic variables described in WorldClim (Hijmans et al. 2005) were generated from the downscaled data. This procedure was done using a script developed by Matheus Lima-Ribeiro in <a href="https://github.com/ecoClimate" target="_blank">https://github.com/ecoClimate</a>.

**IMPLEMENTATION**

The dataset available in Wallace includes simulations for modern times (1950-1999), the Mid-Holocene (6ka), and the Last Glacial Maximum (21ka) for nine AOGCMs. Users also may select among the 19 bioclimatic variables to be used in Wallace. The ecoClimate dataset includes air temperature and precipitation of the entire Earth extent.

**REFERENCES**

Hijmans, R.J., Cameron, S.E., Parra, J.L., Jones, P.G., & Jarvis, A. (2005). Very high resolution interpolated climate surfaces for global land areas. *International Journal of Climatology*, 25(15),  1965-1978. <a href="https://doi.org/10.1002/joc.1276" target="_blank">https://doi.org/10.1002/joc.1276</a> 

Lima-Ribeiro, M.S., Varela, S., González-Hernández, J., de Oliveira, G., Diniz-Filho, J.A.F., & Terribile, L.C. (2015). EcoClimate: a database of climate data from multiple models for past, present, and future for macroecologists and biogeographers. *Biodiversity Informatics*, 10, 1-21. <a href="https://doi.org/10.17161/bi.v10i0.4955" target="_blank">https://doi.org/10.17161/bi.v10i0.4955</a> 

Varela, S., Lima-Ribeiro, M. S., & Terribile, L. C. (2015). A Short Guide to the Climatic Variables of the Last Glacial Maximum for Biogeographers. *PloS One*, 10(6), e0129037. <a href="https://doi.org/10.1371/journal.pone.0129037" target="_blank">https://doi.org/10.1371/journal.pone.0129037</a> 

Wilby, R.L., Charles, S.P., Zorita, E., Timbal, B., Whetton, P., Mearns, L.O. (2004). Guidelines for use of climate scenarios developed from statistical downscaling methods. *Intergovernmental Panel on Climate Change Report supporting material*, Available from the DDC of IPCC TGCIA. <a href="https://www.ipcc-data.org/guidelines/dgm_no2_v1_09_2004.pdf" target="_blank">https://www.ipcc-data.org/guidelines/dgm_no2_v1_09_2004.pdf</a> 
