% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isochrone_png.R
\name{isochrone_png}
\alias{isochrone_png}
\title{Issue a walkalytics isochrone query}
\usage{
isochrone_png(x, y, epsg = 3857, max_min = 1000, break_values = c(0, 3, 6,
  9, 13), key = "my_walkalytics_key")
}
\arguments{
\item{x}{x-coordinate of the source location (coordinate system is WGS/84 Pseudo Mercator).}

\item{y}{y-coordinate of the source location (coordinate system is WGS/84 Pseudo Mercator).}

\item{epsg}{EPSG code for coordinate system of the x- and y-coordinate.}

\item{max_min}{integer. Maximum number of minutes for the isochrone.}

\item{break_values}{a vector of break values (walking time in minutes) for the classification of the PNG result.}

\item{key}{your \code{walkalytics} subscription key which provides access to the API.}
}
\value{
The \link[httr]{response} object from the request. Use \link[walkalytics]{save_png} to save the base64-encoded
    PNG to file.
}
\description{
\code{isochrone_png} calls the \code{walkalytics} isochrone API which calculates the walking isochrone for a source location
    and returns a repsonse object that contains a base64-encoded raster as PNG file with classified isochrones.
}
\details{
To get an API key, you need to register at \url{https://dev.walkalytics.com/signin}.
     With the free starter account, you can make up to 100 calls a week to the API.
}
\examples{
\donttest{
isochrone_png(x = 895815, y = 6004839, key = "abcd1234")
}

}
\references{
\href{https://dev.walkalytics.com/docs/services/}{Walkalytics API documentations}
}
