% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isochrone_esri.R
\name{isochrone_esri}
\alias{isochrone_esri}
\title{Issue a walkalytics isochrone query}
\usage{
isochrone_esri(x, y, epsg = 3857, max_min = 1000,
  key = "my_walkalytics_key")
}
\arguments{
\item{x}{x-coordinate of the source location (coordinate system is WGS/84 Pseudo Mercator).}

\item{y}{y-coordinate of the source location (coordinate system is WGS/84 Pseudo Mercator).}

\item{epsg}{EPSG code for coordinate system of the x- and y-coordinate.}

\item{max_min}{maximum number of minutes for the isochrone.}

\item{key}{your \code{walkalytics} subscription key which provides access to the API.}
}
\value{
The \link[httr]{response} object from the request. Use \link[walkalytics]{esri_to_sgdf} to convert the base64-encoded
    gzipped Esri ASCII grid to an object of class \link[sp]{SpatialGridDataFrame-class}. Use \link[walkalytics]{pixel_walktimes}
    to directly extract walking times for every pixel.
}
\description{
\code{isochrone_esri} calls the \code{walkalytics} isochrone API which calculates the walking isochrone for a source location
    and returns a repsonse object that contains a base64-encoded gzipped Esri ASCII grid with walking times for every pixel.
}
\details{
To get an API key, you need to register at \url{https://dev.walkalytics.com/signin}.
    With the free starter account, you can make up to 100 calls a week to the API.
}
\examples{
\donttest{
isochrone_esri(x = 895815, y = 6004839, key = "abcd1234")
}

}
\references{
\href{https://dev.walkalytics.com/docs/services/}{Walkalytics API documentations}
}
