% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/military.R
\name{military}
\alias{military}
\title{Generate Random Vector of Military Branches}
\usage{
military(n, x = c("Army", "Air Force", "Navy", "Marine Corps", "Coast Guard"),
  prob = c(0.3785, 0.2334, 0.2218, 0.1366, 0.0296), name = "Military")
}
\arguments{
\item{n}{The number elements to generate.  This can be globally set within
the environment of \code{r_data_frame} or \code{r_list}.}

\item{x}{A vector of elements to chose from.}

\item{prob}{A vector of probabilities to chose from.}

\item{name}{The name to assign to the output vector's \code{varname}
attribute.  This is used to auto assign names to the column/vector name when
used inside of \code{r_data_frame} or \code{r_list}.}
}
\value{
Returns a random factor vector of military branch elements.
}
\description{
Generate a random vector of military branches.
}
\details{
The military branches and probabilities used match approximate U.S.
military make-up:

\tabular{lrr}{
  \bold{ Branch} \tab \bold{N} \tab \bold{Percent} \cr
  Army         \tab 541,291 \tab 37.9\%\cr
  Air Force    \tab 333,772 \tab 23.3\%\cr
  Navy         \tab 317,237 \tab 22.2\%\cr
  Marine Corps \tab 195,338 \tab 13.7\%\cr
  Coast Guard  \tab 42,357  \tab 3.0\%\cr
}
}
\examples{
military(10)
barplot(table(military(10000)))
pie(table(military(10000)))
}
\seealso{
Other variable.functions: \code{\link{age}};
  \code{\link{animal}}, \code{\link{pet}};
  \code{\link{answer}}; \code{\link{area}};
  \code{\link{birth}}, \code{\link{dob}};
  \code{\link{car}}; \code{\link{children}};
  \code{\link{coin}}; \code{\link{color}},
  \code{\link{primary}}; \code{\link{date_stamp}};
  \code{\link{death}}, \code{\link{died}};
  \code{\link{dice}}; \code{\link{dna}};
  \code{\link{dummy}}; \code{\link{education}};
  \code{\link{ela}}, \code{\link{level}},
  \code{\link{math}}; \code{\link{employment}};
  \code{\link{eye}}; \code{\link{gender_inclusive}},
  \code{\link{sex_inclusive}}; \code{\link{gender}},
  \code{\link{sex}}; \code{\link{gpa}},
  \code{\link{grade}}, \code{\link{grade_letter}};
  \code{\link{grade_level}}; \code{\link{group}};
  \code{\link{hair}}; \code{\link{height}},
  \code{\link{height_cm}}, \code{\link{height_in}};
  \code{\link{income}}; \code{\link{internet_browser}};
  \code{\link{iq}}; \code{\link{language}};
  \code{\link{likert}}, \code{\link{likert_5}},
  \code{\link{likert_7}}; \code{\link{lorem_ipsum}},
  \code{\link{paragraph}}; \code{\link{lower}},
  \code{\link{lower_factor}}, \code{\link{upper}},
  \code{\link{upper_factor}}; \code{\link{marital}};
  \code{\link{month}}; \code{\link{name}};
  \code{\link{normal}}, \code{\link{normal_round}};
  \code{\link{political}}; \code{\link{race}};
  \code{\link{religion}}; \code{\link{sat}};
  \code{\link{sentence}}; \code{\link{smokes}};
  \code{\link{speed}}, \code{\link{speed_kph}},
  \code{\link{speed_mph}}; \code{\link{state}};
  \code{\link{string}}; \code{\link{valid}};
  \code{\link{year}}; \code{\link{zip_code}}
}
\keyword{army}
\keyword{branch}
\keyword{marines}
\keyword{military}
\keyword{navy}

