% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inequalityMeasure.R
\name{Kolm}
\alias{Kolm}
\title{Kolm index}
\usage{
Kolm(X, W = rep(1, length(X)), parameter = 1, scale = "None")
}
\arguments{
\item{X}{is a data vector}

\item{W}{is a vector of weights}

\item{parameter}{is a Kolm parameter}

\item{scale}{method of data scaling (None, Normalization, Unitarization, Standardization)}
}
\value{
The value of Kolm coefficient.
}
\description{
Computes Kolm inequality measure of a given variable taking into account weights.
}
\details{
Kolm index with parameter \eqn{\alpha}  is defined as:
\deqn{K = \frac{1}{ \alpha} (log( \sum_{i=1}^n \exp(\alpha (w_{i} - \mu)) - log(n)))}

Kolm index is scale-dependent. Basic normalization methods can be applied before final computation.
}
\examples{
# Compare weighted and unweighted result
X=1:10
W=1:10
Kolm(X)
Kolm(X,W)

# Compare raw and standardized data.
Kolm(X,W)
Kolm(X,W, scale ="Standardization")

# Changing units has an impact on the final result
Kolm(X)
Kolm(10*X)

# Changing units has no impact on the final result with standardized data
Kolm(X,scale ="Standardization")
Kolm(10*X,scale ="Standardization")

}
\references{
Kolm S. C.: (1976) Unequal inequalities I and II

Kolm S. C.: (1996) Intermediate measures of inequality

Chakravarty S. R.: (2009) Inequality, Polarization and Poverty  e-ISBN 978-0-387-79253-8
}
