% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outOfSample.R
\name{kWayStratifiedYReplace}
\alias{kWayStratifiedYReplace}
\title{k-fold cross validation stratified with replacement on y, a splitFunction in the sense of vtreat::buildEvalSets .}
\usage{
kWayStratifiedYReplace(nRows, nSplits, dframe, y)
}
\arguments{
\item{nRows}{number of rows to split (>1)}

\item{nSplits}{number of groups to split into (<nRows,>1).}

\item{dframe}{original data frame (ignored).}

\item{y}{numeric outcome variable try to have equidistributed in each split.}
}
\value{
split plan
}
\description{
Build a k-fold cross validation sample where training sets are the same size as the original data,
and built by sampling disjoint from test/application sets (sampled with replacement).
}
\examples{

set.seed(23255)
d <- data.frame(y=sin(1:100))
pStrat <- kWayStratifiedYReplace(nrow(d),5,d,d$y)

}
