% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rquery_treatment.R
\name{rqdatatable_prepare}
\alias{rqdatatable_prepare}
\title{Apply a treatment plan using rqdatatable.}
\usage{
rqdatatable_prepare(rqplan, data_source, ..., partition_column = NULL,
  parallelCluster = NULL, use_parallel = use_parallel,
  extracols = NULL, non_join_mapping = FALSE, print_rquery = FALSE,
  env = parent.frame())
}
\arguments{
\item{rqplan}{an query plan produced by as_rquery_plan().}

\item{data_source}{a data.frame.}

\item{...}{force later arguments to bind by name.}

\item{partition_column}{character name of column to partition work by.}

\item{parallelCluster}{a cluster object, created by package parallel or by package snow. If NULL, use the registered default cluster.}

\item{use_parallel}{logical, if TRUE use parallel cluster (when available).}

\item{extracols}{extra columns to copy.}

\item{non_join_mapping}{logical, if TRUE use non-join based column mapping.}

\item{print_rquery}{logical, if TRUE print the rquery ops.}

\item{env}{environment to work in.}
}
\value{
treated data.
}
\description{
Note: does not treat map NaN or +-Infinity.  
This function is only for timings and demonstration, not for production use.
}
\seealso{
\code{\link{as_rquery_plan}}, \code{\link{rquery_prepare}}
}
\keyword{internal}
