% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_factorization.R
\name{sim_factors}
\alias{sim_factors}
\title{Simulate matrices to explores \code{vrnmf}}
\usage{
sim_factors(
  m,
  n,
  r,
  simplex = "col",
  distr = "unif",
  frac.zeros = 0.4,
  condition = FALSE,
  noise = 0
)
}
\arguments{
\item{m}{Integers. Size of matrices. Matrix \code{C} has a size of \code{m*r}
and matrix \code{D} has a size of \code{r*n}.}

\item{n}{Integers. Size of matrices. Matrix \code{C} has a size of \code{m*r}
and matrix \code{D} has a size of \code{r*n}.}

\item{r}{Integers. Size of matrices. Matrix \code{C} has a size of \code{m*r}
and matrix \code{D} has a size of \code{r*n}.}

\item{simplex}{A character. Either columns ("col") or rows ("row") of matrix \code{C} are projected onto unit simplex. (default="col")}

\item{distr}{A character. Distribution to simulate matrix entries: "unif" for uniform and "exp" for exponential distributions. (default="unif")}

\item{frac.zeros}{A numeric. Fraction of zeros in matrix \code{C}. It promotes sufficient scattering of matrix column/row vectors. (default=0.4)}

\item{condition}{A boolean. Generate more well-conditioned matrix \code{R}. (default=FALSE)}

\item{noise}{A numeric. Standard deviation of gaussian noise to add. (default=0e-4)}
}
\value{
List of simulated matrices:

\code{X.noise}, \code{X} - noisy and original matrix \code{X} to decompose.

\code{C}, \code{D} - factorization matrices.
}
\description{
\code{sim_factors} simulates non-negative factorization matrices \code{C} and \code{D}
under a variaty of conditions to explore factorization \eqn{X = C*D + noise}.
}
