/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

class Evaluator {
    public Vector expressions;
    public Vector variable_names;
    public Vector initial_variable_values;
    public int independent_variables_count;
    public double[] variable_values;
    public double[] last_valid_variable_values;
    public int max_expression_list_size;
    public double[] evaluation_stack;
    public static final int max_arguments_count = 3;
    public double seconds_since_1970 = (double)System.currentTimeMillis() / 1000.0;

    public Evaluator() {
        this.clearAllVariables();
    }

    public void clearAllVariables() {
        this.expressions = null;
        this.variable_names = null;
        this.initial_variable_values = null;
        this.independent_variables_count = 0;
        this.variable_values = null;
        this.last_valid_variable_values = null;
        this.max_expression_list_size = 0;
        this.evaluation_stack = null;
    }

    public boolean addIndependentVariable(String name, double initial_value) {
        if (null == this.variable_names) {
            this.variable_names = new Vector();
        }
        if (null == this.initial_variable_values) {
            this.initial_variable_values = new Vector();
        }
        if (this.independent_variables_count < this.variable_names.size()) {
            return false;
        }
        if (this.getVariableIndex(name) >= 0) {
            return false;
        }
        this.variable_names.addElement(name);
        this.initial_variable_values.addElement(new Double(initial_value));
        this.independent_variables_count = this.variable_names.size();
        return true;
    }

    public boolean addDependentVariable(String name, double initial_value, int expression_index) {
        int index;
        if (null == this.variable_names) {
            this.variable_names = new Vector();
        }
        if (null == this.initial_variable_values) {
            this.initial_variable_values = new Vector();
        }
        if ((index = this.getVariableIndex(name)) >= 0) {
            if (!this.isVariableIndependent(index)) {
                return false;
            }
            if (expression_index < 0) {
                return false;
            }
        }
        if (index < 0) {
            this.variable_names.addElement(name);
            this.initial_variable_values.addElement(new Double(initial_value));
            index = this.variable_names.size() - 1;
        }
        if (expression_index >= 0) {
            this.getExpression(expression_index).setVariable(index);
        }
        return true;
    }

    public void prepareVariables() {
        if (null == this.variable_names) {
            return;
        }
        this.variable_values = new double[this.variable_names.size()];
        this.last_valid_variable_values = new double[this.variable_names.size()];
        this.setInitialVariableValues();
        this.confirmVariableValues();
    }

    public void setInitialVariableValues() {
        if (null == this.initial_variable_values) {
            return;
        }
        for (int index = 0; index < this.initial_variable_values.size(); ++index) {
            this.variable_values[index] = (Double)this.initial_variable_values.elementAt(index);
        }
    }

    public void resetVariableValues() {
        if (null == this.variable_names) {
            return;
        }
        for (int index = 0; index < this.variable_names.size(); ++index) {
            this.variable_values[index] = this.last_valid_variable_values[index];
        }
    }

    public void confirmVariableValues() {
        if (null == this.variable_names) {
            return;
        }
        for (int index = 0; index < this.variable_names.size(); ++index) {
            this.last_valid_variable_values[index] = this.variable_values[index];
        }
    }

    public void setVariableValue(int index, double value) {
        if (null != this.variable_values) {
            this.variable_values[index] = value;
        } else {
            this.initial_variable_values.setElementAt(new Double(value), index);
        }
    }

    public double getVariableValue(int index) {
        if (null != this.variable_values) {
            return this.variable_values[index];
        }
        return (Double)this.initial_variable_values.elementAt(index);
    }

    public int getVariableIndex(String name) {
        int found_index = -1;
        if (null == this.variable_names) {
            return -1;
        }
        for (int index = 0; index < this.variable_names.size(); ++index) {
            if (!name.equals((String)this.variable_names.elementAt(index))) continue;
            found_index = index;
            break;
        }
        return found_index;
    }

    public boolean isVariableIndependent(int index) {
        return index >= 0 && index < this.independent_variables_count;
    }

    public int addExpression(Expression new_expression) {
        if (null == this.expressions) {
            this.expressions = new Vector();
        }
        this.expressions.addElement(new_expression);
        if (new_expression.list_size > this.max_expression_list_size) {
            this.max_expression_list_size = new_expression.list_size;
            this.evaluation_stack = new double[this.max_expression_list_size + 3];
        }
        return this.expressions.size() - 1;
    }

    public Expression getExpression(int index) {
        return (Expression)this.expressions.elementAt(index);
    }

    public double getExpressionValue(int index) {
        return ((Expression)this.expressions.elementAt((int)index)).current_value;
    }

    public void setExpressionCoordinate(int index, Graphics3D graphics, int point_index, int coordinate_index) {
        this.getExpression(index).setCoordinate(graphics, point_index, coordinate_index);
    }

    public void setExpressionIfCondition(int index, Graphics3D new_graphics, int flag, int if_min_index, int if_max_index, int else_min_index, int else_max_index, int default_min_index, int default_max_index) {
        this.getExpression(index).setIfCondition(new_graphics, flag, if_min_index, if_max_index, else_min_index, else_max_index, default_min_index, default_max_index);
    }

    public boolean evaluate() {
        boolean valid = true;
        if (null == this.expressions) {
            this.expressions = new Vector();
        }
        this.confirmVariableValues();
        for (int expression_index = 0; expression_index < this.expressions.size(); ++expression_index) {
            Expression expression = (Expression)this.expressions.elementAt(expression_index);
            expression.confirmValue();
            if (expression.evaluate()) continue;
            for (int index = 0; index <= expression_index; ++index) {
                expression = (Expression)this.expressions.elementAt(index);
                expression.resetValue();
            }
            this.resetVariableValues();
            valid = false;
            break;
        }
        return valid;
    }
}

