% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fileToMatrix.R
\name{fileToMatrix}
\alias{fileToMatrix}
\title{function to get an ine or an ext file and returns the corresponding polytope}
\usage{
fileToMatrix(path, zonotope)
}
\arguments{
\item{path}{A string that containes the path to an ine or a ext file. The ine file desrcibes a H-polytope and ext file describes a V-polytope or a zonotope.}

\item{zonotope}{A boolean parameter. It has to be TRUE when the path leads to an .ext file that describes a zonotope.}
}
\value{
A polytope class. If the path corresponds to an ine file then the return value represents a H-polytope. If it corresponds to an ext file the return value represents a V-polytope (default choice) or a zonotope if the second argument is TRUE.
}
\description{
For an ine file it generates the corresponding H-polytope. For an ext file it generates the corresponding V-polytope or zonotope.
}
\examples{
# give the path to birk4.ine
path = system.file('extdata', package = 'volesti')
P = fileToMatrix(paste0(path,'/birk4.ine'))
}
