% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{SliceOfSimplex}
\alias{SliceOfSimplex}
\title{Compute the percentage of the volume of the unit simplex that is contained in the intersection of a half-space and the unit simplex.}
\usage{
SliceOfSimplex(a, z0)
}
\arguments{
\item{a}{A \eqn{d}-dimensional vector that defines the direction of the hyperplane.}

\item{z0}{The scalar that defines the half-space.}
}
\value{
The percentage of the volume of the unit simplex that is contained in the intersection of a given half-space and the unit simplex.
}
\description{
A half-space \eqn{H} is given as a pair of a vector \eqn{a\in R^d} and a scalar \eqn{z0\in R} s.t.: \eqn{a^Tx\leq z0}. This function calls the Ali's version of the Varsi formula to compute a frustum of the unit simplex.
}
\examples{
# compute the frustum of H: -x1+x2<=0
a=c(-1,1)
z0=0
frustum = SliceOfSimplex(a, z0)
}
\references{
\cite{Varsi, Giulio,
\dQuote{The multidimensional content of the frustum of the simplex,} \emph{Pacific J. Math. 46, no. 1, 303--314,} 1973.}

\cite{Ali, Mir M.,
\dQuote{Content of the frustum of a simplex,} \emph{ Pacific J. Math. 48, no. 2, 313--322,} 1973.}
}
