% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/viviUpdate.R
\name{viviUpdate}
\alias{viviUpdate}
\title{viviUpdate}
\usage{
viviUpdate(mat, newImp)
}
\arguments{
\item{mat}{A matrix, such as that returned by \code{vivi}.}

\item{newImp}{A named vector of variable importances.}
}
\value{
A matrix of values, of class vivid, with updated variable importances.
}
\description{
Creates a matrix displaying updated variable importance on the diagonal
and variable interaction on the off-diagonal.
}
\examples{
f <- lm(Sepal.Length ~ ., data = iris[, -5])
m <- vivi(iris[, -5], f, "Sepal.Length")
corimp <- abs(cor(iris[, -5])[1, -1])
viviUpdate(m, corimp) # use correlation as updated importance
}
