% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_IV.R
\name{create_IV}
\alias{create_IV}
\title{Compute Information Value for Predictive Variables}
\usage{
create_IV(
  data,
  predictors = NULL,
  outcome,
  bins = 5,
  siglevel = 0.05,
  exc_sig = FALSE,
  return = "plot"
)
}
\arguments{
\item{data}{A Person Query dataset in the form of a data frame.}

\item{predictors}{A character vector specifying the columns to be used as
predictors. Defaults to NULL, where all numeric vectors in the data will be
used as predictors.}

\item{outcome}{String specifying the column name for a binary variable,
containing only the values 1 or 0.}

\item{bins}{Number of bins to use, defaults to 5.}

\item{siglevel}{Significance level to use in comparing populations for the
outcomes, defaults to 0.05}

\item{exc_sig}{Logical value determining whether to exclude values where the
p-value lies below what is set at \code{siglevel}. Defaults to \code{FALSE}, where
p-value calculation does not happen altogether.}

\item{return}{String specifying what to return. This must be one of the
following strings:
\itemize{
\item \code{"plot"}
\item \code{"summary"}
\item \code{"list"}
\item \code{"plot-WOE"}
\item \code{"IV"}
}

See \code{Value} for more information.}
}
\value{
A different output is returned depending on the value passed to the \code{return}
argument:
\itemize{
\item \code{"plot"}: 'ggplot' object. A bar plot showing the IV value of the top
(maximum 12) variables.
\item \code{"summary"}: data frame. A summary table for the metric.
\item \code{"list"}: list. A list of outputs for all the input variables.
\item \code{"plot-WOE"}: A list of 'ggplot' objects that show the WOE for each
predictor used in the model.
\item \code{"IV"} returns a list object which mirrors the return
in \code{Information::create_infotables()}.
}
}
\description{
This function calculates the Information Value (IV) for the
selected numeric predictor variables in the dataset, given a specified
outcome variable. The Information Value provides a measure of the predictive
power of each variable in relation to the outcome variable, which can be
useful in feature selection for predictive modeling.
}
\details{
This is a wrapper around \code{wpa::create_IV()}.
}
\examples{
# Return a summary table of IV
pq_data \%>\%
  dplyr::mutate(X = ifelse(Internal_network_size > 40, 1, 0)) \%>\%
  create_IV(outcome = "X",
            predictors = c("Email_hours",
                           "Meeting_hours",
                           "Chat_hours"),
            return = "plot")


# Return summary
pq_data \%>\%
  dplyr::mutate(X = ifelse(Internal_network_size > 40, 1, 0)) \%>\%
  create_IV(outcome = "X",
            predictors = c("Email_hours", "Meeting_hours"),
            return = "summary")

}
\seealso{
Other Variable Association: 
\code{\link{IV_report}()}

Other Information Value: 
\code{\link{IV_report}()}
}
\concept{Information Value}
\concept{Variable Association}
