% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supporting_functions.R
\name{extract_date_range}
\alias{extract_date_range}
\title{Extract date period}
\usage{
extract_date_range(data, return = "table")
}
\arguments{
\item{data}{Data frame containing a query to pass through.
The data frame must contain a \code{Date} column.
Accepts a Person query or a Meeting query.}

\item{return}{String specifying what output to return.
Returns a table by default ("table"), but allows returning
a descriptive string ("text").}
}
\value{
A different output is returned depending on the value passed to the \code{return}
argument:
\itemize{
\item \code{"table"}: data frame. A summary table containing the start and end date
for the dataset.
\item \code{"text"}: string. Contains a descriptive string on the start and end date
for the dataset.
}
}
\description{
Return a data frame with the start and end date
of the query data by default. There are options to return a descriptive
string, which is used in the caption of plots in this package.
}
\seealso{
Other Support: 
\code{\link{camel_clean}()},
\code{\link{check_inputs}()},
\code{\link{cut_hour}()},
\code{\link{extract_hr}()},
\code{\link{heat_colours}()},
\code{\link{is_date_format}()},
\code{\link{maxmin}()},
\code{\link{pairwise_count}()},
\code{\link{read_preamble}()},
\code{\link{rgb2hex}()},
\code{\link{totals_bind}()},
\code{\link{totals_col}()},
\code{\link{tstamp}()},
\code{\link{us_to_space}()},
\code{\link{wrap}()}
}
\concept{Support}
