% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visit_simu.R
\name{vtSingleTrial}
\alias{vtSingleTrial}
\title{Simulate a single trial}
\usage{
vtSingleTrial(trueps, size.cohort = 3, size.level = NULL,
  etas = c(0.1, 0.3), dec.cut = 0.65, prob.mdl = c("NONPARA",
  "NONPARA+", "PARA", "PARA+"), priors = NULL, ...)
}
\arguments{
\item{trueps}{True \eqn{\theta}'s. A \code{VTTRUEPS} object made from
\code{\link{vtScenario}}}

\item{size.cohort}{Size of each cohort}

\item{size.level}{Maximum number of patients for each dose level}

\item{etas}{Vector of length 2 representing \eqn{(p_L, p_U)}. \eqn{p_L}: lower
bound of DLT risk, below which the current dose is considered absolutely
safe; \eqn{p_U}: upper bound of DLT risk above which the current dose is
considered too toxic}

\item{dec.cut}{Thresholds \eqn{C_1,C_2,C_3}. If the vector length is shorter
than \eqn{3}, it is repeated to have \eqn{3} elements. See
\code{\link{visit}} for details.}

\item{prob.mdl}{Option of the probability models:

\itemize{\item{NONPARA: }{non-parametric+ model}

 \item{NONPARA+: }{non-parametric model}

\item{PARA: }{partially parametric model}

\item{PARA+: }{partially parametric+ model} }

Default value is \code{NONPARA}. See \code{\link{visit}} for details.}

\item{priors}{A class \code{VTPRIOR} object created by
\code{\link{vtPriorPar}} for \code{PARA} and \code{PARA+} model.}

\item{...}{Optional arguments for \code{vtPost}}
}
\value{
\itemize{
\item{\code{dose}: }{Optimal dose level}
\item{\code{n.patients}: }{Number of patients for each dose level and each cohort}
\item{\code{ptox}: }{Posterior mean of DLT risk rate after each interim analysis}
\item{\code{pres}: }{Posterior mean of immune response rate after each interim analysis}
\item{\code{region}: }{Identified region in the decision map after each interim analysis}
\item{\code{prob}: }{Posterior mean of \eqn{\theta}'s after each interim analysis}
\item{\code{smps}: }{Observed data after each cohort}
}
}
\description{
Simulation function for simulating a single trial
}
\examples{
rst.sce <- vtScenario(tox = c(0.05, 0.05, 0.08),
                      res = c(0.2, 0.3, 0.5),
                      rho = 1)
rst.simu  <- vtSingleTrial(trueps = rst.sce, size.cohort=3, size.level=12,
                           prob.mdl="NONPARA");

}
