% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visit_simu.R
\name{summary.VTSIMU}
\alias{summary.VTSIMU}
\title{Summarize simulation results}
\usage{
\method{summary}{VTSIMU}(object, ...)
}
\arguments{
\item{object}{A class \code{VTSIMU} list generated by \code{\link{vtSimu}}}

\item{...}{Reserved parameters}
}
\value{
A list containing
\itemize{
\item{dose}{: Frequency for each dose level being selected as the optimal dose level}
\item{npat}{: Average number of patients for each cohort and each dose level}
\item{samples}{: Average number of DLT risks and responses for each cohort on each dose level}
\item{decision}{: Frequency each region in the decision map is selected for each cohort on each dose level}

\item{prob}{: Average conditional probabilities corresponding to each region in
the decision map for each cohort on each dose level}

\item{ptox}{: Mean and credible interval of DLT risk rates for each cohort on each dose level}

\item{pres}{: Mean and credible interval of immune response rates for each cohort on each dose level}
}
}
\description{
Summarize the simulation results with numerous statistical measures
}
\examples{
rst.sce <- vtScenario(tox = c(0.05, 0.05, 0.08),
                      res = c(0.2, 0.3, 0.5),
                      rho = 1)
rst.simu  <- vtSimu(n.rep = 50, n.cors = 2, trueps = rst.sce,
                    size.cohort=3, size.level=12,
                    prob.mdl="NONPARA");
sum.simu <- summary(rst.simu)

}
