% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatTable.R
\name{formatTable}
\alias{formatTable}
\title{Creates a flextable or gt object from a dataframe}
\usage{
formatTable(
  x,
  type = "gt",
  delim = "\\n",
  style = "default",
  na = "-",
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  groupColumn = NULL,
  groupAsColumn = FALSE,
  groupOrder = NULL,
  merge = NULL
)
}
\arguments{
\item{x}{A dataframe.}

\item{type}{The desired format of the output table. See \code{tableType()} for
allowed options.}

\item{delim}{Delimiter to separate headers.}

\item{style}{A character string or custom R code to define the visual
formatting of the table. This argument can be provided in two ways:
\enumerate{
\item Pre-defined Styles (Character String): Use a name for a built-in style
(e.g., "darwin"). See tableStyle() for available options.
\item Custom Code (Advanced): Supply a block of custom R code. This code must be
specific to the table type. See tableStyleCode() for structural examples.
}}

\item{na}{How to display missing values. Not used for "datatable" and
"reactable".}

\item{title}{Title of the table, or NULL for no title. Not used for
"datatable".}

\item{subtitle}{Subtitle of the table, or NULL for no subtitle. Not used for
"datatable" and "reactable".}

\item{caption}{Caption for the table, or NULL for no caption. Text in
markdown formatting style (e.g. \verb{*Your caption here*} for caption in
italics). Not used for "reactable".}

\item{groupColumn}{Columns to use as group labels, to see options use
\code{tableColumns(result)}. By default, the name of the new group will be the
tidy* column names separated by ";". To specify a custom group name, use a
named list such as:
list("newGroupName" = c("variable_name", "variable_level")).

*tidy: The tidy format applied to column names replaces "_" with a space and
converts to sentence case. Use \code{rename} to customise specific column names.}

\item{groupAsColumn}{Whether to display the group labels as a column
(TRUE) or rows (FALSE). Not used for "datatable" and "reactable"}

\item{groupOrder}{Order in which to display group labels. Not used for
"datatable" and "reactable".}

\item{merge}{Names of the columns to merge vertically when consecutive row
cells have identical values. Alternatively, use "all_columns" to apply this
merging to all columns, or use NULL to indicate no merging. Not used for
"datatable" and "reactable".}
}
\value{
A formatted table of the class selected in "type" argument.
}
\description{
Creates a flextable object from a dataframe using a delimiter to span
the header, and allows to easily customise table style.
}
\examples{
# Example 1
mockSummarisedResult() |>
  formatEstimateValue(decimals = c(integer = 0, numeric = 1)) |>
  formatHeader(
    header = c("Study strata", "strata_name", "strata_level"),
    includeHeaderName = FALSE
  ) |>
  formatTable(
    type = "flextable",
    style = "default",
    na = "--",
    title = "fxTable example",
    subtitle = NULL,
    caption = NULL,
    groupColumn = "group_level",
    groupAsColumn = TRUE,
    groupOrder = c("cohort1", "cohort2"),
    merge = "all_columns"
  )

# Example 2
mockSummarisedResult() |>
  formatEstimateValue(decimals = c(integer = 0, numeric = 1)) |>
  formatHeader(header = c("Study strata", "strata_name", "strata_level"),
              includeHeaderName = FALSE) |>
  formatTable(
    type = "gt",
    style = list("header" = list(
      gt::cell_fill(color = "#d9d9d9"),
      gt::cell_text(weight = "bold")),
      "header_level" = list(gt::cell_fill(color = "#e1e1e1"),
                            gt::cell_text(weight = "bold")),
      "column_name" = list(gt::cell_text(weight = "bold")),
      "title" = list(gt::cell_text(weight = "bold"),
                     gt::cell_fill(color = "#c8c8c8")),
      "group_label" = gt::cell_fill(color = "#e1e1e1")),
    na = "--",
    title = "gtTable example",
    subtitle = NULL,
    caption = NULL,
    groupColumn = "group_level",
    groupAsColumn = FALSE,
    groupOrder = c("cohort1", "cohort2"),
    merge = "all_columns"
  )

}
