% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visCollapse.R
\name{visNetwork-collapse}
\alias{visNetwork-collapse}
\alias{visCollapse}
\alias{visUncollapse}
\title{Network visualization collapse / uncollapsed method}
\usage{
visCollapse(graph, nodes, fit = FALSE, resetHighlight = TRUE,
  clusterOptions = NULL, labelSuffix = "(cluster)")

visUncollapse(graph, nodes = NULL, fit = FALSE,
  resetHighlight = TRUE, keepCoord = TRUE)
}
\arguments{
\item{graph}{: a \code{\link{visNetworkProxy}}  object}

\item{nodes}{: a vector of nodes id. NULL for \code{visUncollapse} for open all collapsed nodes}

\item{fit}{: Optional. Boolean. Default to FALSE. Call fit method after collapse/uncollapse event ?}

\item{resetHighlight}{: Optional. Boolean. Default to TRUE to reset highlighted nodes after collapse/uncollapse event.}

\item{clusterOptions}{: Optional. List. Defaut to NULL. A list of all options you want to pass to cluster collapsed node}

\item{labelSuffix}{: Optional. Character. Use node label + suffix or just suffix. Default to '(cluster)'}

\item{keepCoord}{: Optional. Boolean. Default to TRUE to keep nodes coordinates on collapse}
}
\description{
Network visualization collapse / uncollapsed method
}
\examples{
\dontrun{

# have a look to : 

shiny::runApp(system.file("shiny", package = "visNetwork"))

# You can also disable / enabled the double-click event opening cluster
visNetworkProxy("network_id") \%>\% visEvents(type = "off", doubleClick = "networkOpenCluster")
visNetworkProxy("network_id") \%>\% visEvents(type = "on", doubleClick = "networkOpenCluster")

}

}
\references{
See online documentation \url{http://datastorm-open.github.io/visNetwork/}
}
\seealso{
\link{visNodes} for nodes options, \link{visEdges} for edges options, \link{visGroups} for groups options, 
\link{visLegend} for adding legend, \link{visOptions} for custom option, \link{visLayout} & \link{visHierarchicalLayout} for layout, 
\link{visPhysics} for control physics, \link{visInteraction} for interaction, \link{visNetworkProxy} & \link{visFocus} & \link{visFit} for animation within shiny,
\link{visDocumentation}, \link{visEvents}, \link{visConfigure} ...
}
