% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{viralrates}
\alias{viralrates}
\title{Viral Rates Dataset}
\format{
A data frame with 87 rows and 21 variables:
\describe{
\item{cd_2018}{CD4 count in 2018.}
\item{cd_2019}{CD4 count in 2019.}
\item{vl_2019}{Viral load in 2019.}
\item{cd_2021}{CD4 count in 2021.}
\item{vl_2021}{Viral load in 2021.}
\item{cd_2022}{CD4 count in 2022.}
\item{vl_2022}{Viral load in 2022.}
\item{cd_2023}{CD4 count in 2023.}
\item{vl_2023}{Viral load in 2023.}
\item{recovery_rate_2019}{CD4 count recovery rate from 2018 to 2019.}
\item{recovery_rate_2021}{CD4 count recovery rate from 2019 to 2021.}
\item{recovery_rate_2022}{CD4 count recovery rate from 2021 to 2022.}
\item{recovery_rate_2023}{CD4 count recovery rate from 2023 to 2022.}
\item{viral_rate_2021}{Viral load rate of change from 2019 to 2021 (log10).}
\item{viral_rate_2022}{Viral load rate of change from 2021 to 2022 (log10).}
\item{viral_rate_2023}{Viral load rate of change from 2022 to 2023 (log10).}
\item{adherence_1}{First principal component analysis scores representing adherence to ART.}
\item{adherence_2}{Second principal component analysis scores representing adherence to ART.}
\item{adherence_3}{Third principal component analysis scores representing adherence to ART.}
\item{adherence_4}{Fourth principal component analysis scores representing adherence to ART.}
\item{adherence_5}{Fifth principal component analysis scores representing adherence to ART.}
}
}
\usage{
viralrates
}
\description{
The dataset contains information about patients, specifically
their CD4 T cell counts (cd_2018, cd_2019, cd_2021, cd_2022, cd_2023) and
viral loads (vl_2019, vl_2021, vl_2022, vl_2023). For modeling patient
recovery and viral load persistence or suppression, column \code{cd_2023} is
identified as the outcome variable for CD4 cell counts, and column \code{vl_2023}
is identified as the outcome variable for viral load. The dataset also
contains information about variables related to adherence to antiretroviral
therapy (ART).
}
\examples{
\donttest{
  # Load the dataset
  data("viralrates", package = "viruslearner")
  # Explore the dataset
  library(dplyr)
  dplyr::glimpse(viralrates)
}
}
\keyword{datasets}
