% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dashboard.R
\name{vetiver_dashboard}
\alias{vetiver_dashboard}
\alias{get_vetiver_dashboard_pins}
\alias{pin_example_kc_housing_model}
\title{R Markdown format for model monitoring dashboards}
\usage{
vetiver_dashboard(pins = list(), display_pins = TRUE, ...)

get_vetiver_dashboard_pins()

pin_example_kc_housing_model(board = pins::board_local(), name = "seattle_rf")
}
\arguments{
\item{pins}{A list containing \code{board}, \code{name}, and \code{version}, as in
\code{\link[pins:pin_read]{pins::pin_read()}}}

\item{display_pins}{Should the dashboard display a link to the pin(s)?
Defaults to \code{TRUE}, but only creates a link if the pin contains a URL in
its metadata.}

\item{...}{Arguments passed to \code{\link[flexdashboard:flex_dashboard]{flexdashboard::flex_dashboard()}}}

\item{board}{A pin board, created by \code{\link[pins:board_folder]{board_folder()}}, \code{\link[pins:board_connect]{board_connect()}},
\code{\link[pins:board_url]{board_url()}} or another \code{board_} function.}

\item{name}{Pin name.}
}
\description{
R Markdown format for model monitoring dashboards
}
\details{
The \code{vetiver_dashboard()} function is a specialized type of
\pkg{flexdashboard}. See the flexdashboard website for additional
documentation:
\href{https://pkgs.rstudio.com/flexdashboard/}{https://pkgs.rstudio.com/flexdashboard/}

Before knitting the example \code{vetiver_dashboard()} template, execute the
helper function \code{pin_example_kc_housing_model()} to set up demonstration
model and metrics pins needed for the monitoring demo. This function will:
\itemize{
\item fit an example model to training data
\item pin the vetiver model to your own \code{\link[pins:board_folder]{pins::board_local()}}
\item compute metrics from testing data
\item pin these metrics to the same local board
}

These are the steps you need to complete before setting up monitoring your
real model.
}
