% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caret.R, R/glm.R, R/lm.R, R/mlr3.R,
%   R/prepare.R, R/ranger.R, R/tidymodels.R, R/xgboost.R
\name{vetiver_create_description.train}
\alias{vetiver_create_description.train}
\alias{vetiver_prepare_model.train}
\alias{vetiver_create_description.glm}
\alias{vetiver_prepare_model.glm}
\alias{vetiver_create_description.lm}
\alias{vetiver_prepare_model.lm}
\alias{vetiver_create_description.Learner}
\alias{vetiver_prepare_model.Learner}
\alias{vetiver_create_description}
\alias{vetiver_create_description.default}
\alias{vetiver_prepare_model}
\alias{vetiver_prepare_model.default}
\alias{vetiver_create_description.ranger}
\alias{vetiver_prepare_model.ranger}
\alias{vetiver_create_description.workflow}
\alias{vetiver_prepare_model.workflow}
\alias{vetiver_create_description.xgb.Booster}
\title{Model constructor methods}
\usage{
\method{vetiver_create_description}{train}(model)

\method{vetiver_prepare_model}{train}(model)

\method{vetiver_create_description}{glm}(model)

\method{vetiver_prepare_model}{glm}(model)

\method{vetiver_create_description}{lm}(model)

\method{vetiver_prepare_model}{lm}(model)

\method{vetiver_create_description}{Learner}(model)

\method{vetiver_prepare_model}{Learner}(model)

vetiver_create_description(model)

\method{vetiver_create_description}{default}(model)

vetiver_prepare_model(model)

\method{vetiver_prepare_model}{default}(model)

\method{vetiver_create_description}{ranger}(model)

\method{vetiver_prepare_model}{ranger}(model)

\method{vetiver_create_description}{workflow}(model)

\method{vetiver_prepare_model}{workflow}(model)

\method{vetiver_create_description}{xgb.Booster}(model)
}
\arguments{
\item{model}{A trained model, such as an \code{lm()} model or a tidymodels
\code{\link[workflows:workflow]{workflows::workflow()}}.}
}
\description{
These are developer-facing functions, useful for supporting new model types.
Each model supported by \code{\link[=vetiver_model]{vetiver_model()}} uses up to four methods when the
deployable object is created:
\itemize{
\item The \code{vetiver_create_description()} function generates a helpful description
of the model based on its characteristics. This method is required.
\item The \code{\link[=vetiver_create_meta]{vetiver_create_meta()}} function creates the correct \code{\link[=vetiver_meta]{vetiver_meta()}}
for the model. This is especially helpful for specifying which packages are
needed for prediction. A model can use the default method here, which is
to have no special metadata.
\item The \code{\link[=vetiver_ptype]{vetiver_ptype()}} function finds an input data prototype from the
training data (a zero-row slice) to use for checking at prediction time.
This method is required.
\item The \code{vetiver_prepare_model()} function executes last. Use this function
for tasks like checking if the model is trained and reducing the size of the
model via \code{\link[butcher:butcher]{butcher::butcher()}}. A model can use the default method here,
which is to return the model without changes.
}
}
\details{
These are four generics that use the class of \code{model} for dispatch.
}
\examples{

cars_lm <- lm(mpg ~ ., data = mtcars)
vetiver_create_description(cars_lm)
vetiver_prepare_model(cars_lm)

}
