% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age_ldv.R
\name{age_ldv}
\alias{age_ldv}
\title{Returns amount of vehicles at each age}
\usage{
age_ldv(
  x,
  name = "age",
  a = 1.698,
  b = -0.2,
  agemin = 1,
  agemax = 50,
  k = 1,
  bystreet = F,
  net,
  verbose = FALSE,
  namerows,
  time
)
}
\arguments{
\item{x}{Numeric; numerical vector of vehicles with length equal to lines features of road network}

\item{name}{Character; of vehicle assigned to columns of dataframe}

\item{a}{Numeric; parameter of survival equation}

\item{b}{Numeric; parameter of survival equation}

\item{agemin}{Integer; age of newest vehicles for that category}

\item{agemax}{Integer; age of oldest vehicles for that category}

\item{k}{Numeric; multiplication factor. If its length is > 1, it must match the length of x}

\item{bystreet}{Logical; when TRUE it is expecting that 'a' and 'b' are numeric vectors with length equal to x}

\item{net}{SpatialLinesDataFrame or Spatial Feature of "LINESTRING"}

\item{verbose}{Logical;  message with average age and total numer of vehicles}

\item{namerows}{Any vector to be change row.names. For instance, name of
regions or streets.}

\item{time}{Character to be the time units as denominator, eg "1/h"}
}
\value{
dataframe of age distrubution of vehicles
}
\description{
\code{\link{age_ldv}} returns amount of vehicles at each age
}
\note{
The functions age* produce distribution of the circulating fleet by age of use.
The order of using these functions is:

1. If you know the distribution of the vehicles by age of use , use:  \code{\link{my_age}}
2. If you know the sales of vehicles, or the registry of new vehicles,
use \code{\link{age}} to apply a survival function.
3. If you know the theoretical shape of the circulating fleet and you can use
\code{\link{age_ldv}}, \code{\link{age_hdv}} or \code{\link{age_moto}}. For instance,
you dont know the sales or registry of vehicles, but somehow you know
the shape of this curve.
4. You can use/merge/transform/adapt any of these functions.

It consists in a Gompertz equation with default parameters from
1 national emissions inventory for green housegases in Brazil, MCT 2006
}
\examples{
\dontrun{
data(net)
PC_E25_1400 <- age_ldv(x = net$ldv, name = "PC_E25_1400")
plot(PC_E25_1400)
PC_E25_1400 <- age_ldv(x = net$ldv, name = "PC_E25_1400", net = net)
plot(PC_E25_1400)
}
}
\seealso{
Other age: 
\code{\link{age_hdv}()},
\code{\link{age_moto}()},
\code{\link{age}()}
}
\concept{age}
