% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emis_chem.R
\name{emis_chem}
\alias{emis_chem}
\title{Aggregate emissions by lumped groups in chemical mechanism}
\usage{
emis_chem(dfe, mechanism, colby, long = FALSE)
}
\arguments{
\item{dfe}{data.frame with column `emissions` in grams and `pollutant` in long format. It is supposed
that each line is the pollution of some region. Then the `coldby` argument is for include the
name of the region.}

\item{mechanism}{Character, "RADM2_SORG", "CBMZ_MOSAIC", "CPTEC", "GOCART_CPTEC", "MOZEM",
"MOZCEM", "CAMMAM", "MOZMEM", "MOZC_T1_EM", "CB05_OPT1" or "CB05_OPT2"}

\item{colby}{Character indicating column name for aggregating extra column.
For instance, region or province.}

\item{long}{Logical. Do you want data in long format?}
}
\value{
data.frame with lumped groups by chemical mechanism. It transform
emissions in grams to mol.
}
\description{
\code{\link{emis_chem}} aggregates emissions by chemical mechanism
and convert grams to mol. This function reads all hydrocarbos and respective
criteria polluants specified in \code{\link{ef_ldv_speed}} and \code{\link{ef_hdv_speed}}.
}
\note{
This feature is experimental and the mapping of pollutants and lumped
species may change in future.
This function is converting the intial data.frame input into data.table.
To have a comprehensive speciation is necessary enter with a data.frame
with colum 'emission' in long format including another column named 'pollutant' with
species of NMHC, CO, NO, NO2, NH3, SO2, PM2.5 and coarse PM10.

Groups derived from gases has units 'mol' and from aersols 'g'. The aersol
units for WRF-Chem are ug/m^2/s while for CMAQ and CAMx are g/s. So,
leaving the units just in g, allow to make further change while
providing flexibility for several models.
TODO: Enter with wide data.frame, with each line as a each street, each column for pollutant
}
\examples{
\dontrun{
# CO
df <- data.frame(emission = Emissions(1:10))
df$pollutant = "CO"
emis_chem(df, "CBMZ_MOSAIC")
# hexanal
df$pollutant = "hexanal"
emis_chem(df, "CBMZ_MOSAIC")
# propadiene and NO2
df2 <- df1 <- df
df1$pollutant = "propadiene"
df2$pollutant = "NO2"
(dfe <- rbind(df1, df2))
emis_chem(dfe, "CBMZ_MOSAIC")
dfe$region <- rep(letters[1:2], 10)
emis_chem(dfe, "CBMZ_MOSAIC", "region")
emis_chem(dfe, "CBMZ_MOSAIC", "region", TRUE)
}
}
\seealso{
\code{\link{ef_ldv_speed}} \code{\link{ef_hdv_speed}} \code{\link{speciate}} \code{\link{ef_evap}}
}
