% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adt.R
\name{adt}
\alias{adt}
\title{Average daily traffic (ADT) from hourly traffic data.}
\usage{
adt(pc, lcv, hgv, bus, mc, p_pc, p_lcv, p_hgv, p_bus, p_mc,
  expanded = FALSE)
}
\arguments{
\item{pc}{numeric vector for passenger cars}

\item{lcv}{numeric vector for light commercial vehicles}

\item{hgv}{numeric vector for heavy good vehicles or trucks}

\item{bus}{numeric vector for bus}

\item{mc}{numeric vector for motorcycles}

\item{p_pc}{data-frame profile for passenger cars, 24 hours only.}

\item{p_lcv}{data-frame profile for light commercial vehicles, 24 hours only.}

\item{p_hgv}{data-frame profile for heavy good vehicles or trucks, 24 hours only.}

\item{p_bus}{data-frame profile for bus, 24 hours only.}

\item{p_mc}{data-frame profile for motorcycles, 24 hours only.}

\item{expanded}{boolean argument for returning numeric vector or "Vehicles"}
}
\value{
numeric vector of total volume of traffic per link, or data-frames
of expanded traffic
}
\description{
\code{\link{adt}} calculates ADT based on hourly traffic data. The
input traffic data is usually for morning rush hours.
}
\examples{
{
data(net)
data(pc_profile)
p1 <- pc_profile[, 1]
adt1 <- adt(pc = net$ldv*0.75,
            lcv = net$ldv*0.1,
            hgv = net$hdv,
            bus = 0,
            mc = net$ldv*0.15,
            p_pc = p1,
            p_lcv = p1,
            p_hgv = p1,
            p_bus = p1,
            p_mc = p1)
head(adt1)
plot(adt1)
adt2 <- adt(pc = net$ldv*0.75,
            lcv = net$ldv*0.1,
            hgv = net$hdv,
            bus = net$hdv,
            mc = net$ldv*0.15,
            p_pc = p1,
            p_lcv = p1,
            p_hgv = p1,
            p_bus = p1*0, # when zero, must be the same size
            p_mc = p1,
            TRUE)
head(adt2)
plot(adt2) # Class Vehicles
}
}
