% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ef_hdv_scaled.R
\name{ef_hdv_scaled}
\alias{ef_hdv_scaled}
\title{Scaling constant with speed emission factors of Heavy Duty Vehicles}
\usage{
ef_hdv_scaled(df, dfcol, SDC = 34.12, v, t, g, eu, gr, l, p)
}
\arguments{
\item{df}{Dataframe with local emission factor}

\item{dfcol}{Column of the dataframe with the local emission factors eg df$dfcol}

\item{SDC}{Speed of the driving cycle}

\item{v}{Category vehicle: "Coach", "Trucks" or "Ubus"}

\item{t}{Sub-category of of vehicle: "3Axes", "Artic", "Midi", "RT, "Std" and "TT"}

\item{g}{Gross weight of each category: "<=18", ">18", "<=15", ">15 & <=18", "<=7.5",
">7.5 & <=12", ">12 & <=14", ">14 & <=20", ">20 & <=26", ">26 & <=28", ">28 & <=32",
">32", ">20 & <=28", ">28 & <=34", ">34 & <=40", ">40 & <=50" or ">50 & <=60"}

\item{eu}{Euro emission standard: "PRE", "I", "II", "III", "IV" and "V"}

\item{gr}{Gradient or slope of road: -0.06, -0.04, -0.02, 0.00, 0.02. 0.04 or 0.06}

\item{l}{Load of the vehicle: 0.0, 0.5 or 1.0}

\item{p}{Pollutant: "CO", "FC", "NOx" or "HC"}
}
\value{
A list of scaled emission factors g/km
}
\description{
This function creates a list of scaled functions of emission factors. A scaled
emission factor which at a speed of the dricing cycle (SDC) gives a desired value.
This function needs a dataframe with local emission factors with a columns with
the name "Euro_HDV" indicating the Euro equivalence standard, assuming that there are
available local emission factors for several consecutive years.
}
\note{
The length of the list should be equal to the name of the age categories of
a specific type of vehicle
}
\examples{
\dontrun{
# Do not run
data(fe2015)
co1 <- fe2015[fe2015$Pollutant=="CO",]
FE_LT_7_5_D_CO <- ef_hdv_scaled(co1, co1$LT, v = "Trucks", t = "RT",
g = "<=7.5", eu = co1$Euro_HDV, gr = 0, l = 0.5, p = "CO")
length(FE_LT_7_5_D_CO)
}
}
\keyword{emission}
\keyword{factors}
\keyword{speed}
