\name{clean}
\docType{methods}
\alias{clean}
\alias{clean,vegtable-method}

\title{Clean orphaned records in vegtable object.}
\description{
Delete entries in slots \code{header} and \code{species} orphaned by
manipulation of slots.
}
\usage{
\S4method{clean}{vegtable}(object, times=2, ...)
}
\arguments{
\item{object}{A \code{\linkS4class{vegtable}} object.}
\item{times}{Numeric value indicating how many times should be the cleaning be
	repeated.}
\item{...}{Further arguments passed from or to other methods.}
}
\details{
Orphaned records generated by modifications in some slots may cause a loss on
the validity of \code{\linkS4class{vegtable}} objects.
This function should be applied to optimise the allocated size of a
\code{\linkS4class{vegtable}} object, as well.
Since running cleaning only once does not assure the deletion of all orphaned
entries, it is recommended to run it at least twice.
This repetition of cleaning is controlled by the argument \code{'times'}.
}
\value{
A clean \code{\linkS4class{vegtable}} object.
}
\author{
Miguel Alvarez (\email{kamapu78@gmail.com}).
}
\examples{
\donttest{
library(vegtable)
data(Kenya_veg)

## Direct manipulation of slot header generates an invalid object
Kenya_veg@header <- Kenya_veg@header[1:50,]
summary(Kenya_veg)

## Now apply cleaning
Kenya_veg <- clean(Kenya_veg)
summary(Kenya_veg)
}
}
\keyword{methods}
