% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-getters.R
\name{shiny-getters}
\alias{shiny-getters}
\alias{vw_shiny_get_signal}
\alias{vw_shiny_get_event}
\title{Get information from a Vega chart into Shiny}
\usage{
vw_shiny_get_signal(outputId, name, body_value = "value")

vw_shiny_get_event(outputId, event, body_value = "datum")
}
\arguments{
\item{outputId}{\code{character}, shiny \code{outputId} for the vegawidget}

\item{name}{\code{character}, name of the signal (defined in Vega specification)
being monitored}

\item{body_value}{\code{character} or \code{JS_EVAL}, the \strong{body} of a JavaScript
function that Vega will use to handle the signal or event; this function
must return a value}

\item{event}{\code{character}, type of the event being monitored, e.g. \code{"click"},
for list of supported events, please see
\href{https://vega.github.io/vega/docs/event-streams/}{Vega Event-Stream reference}}
}
\value{
\code{\link[shiny:reactive]{shiny::reactive()}} function that returns the value returned by
\code{body_value}
}
\description{
There are two types of information you can get from a Vega chart, a \emph{signal},
and information associated with an \emph{event}. Any such signal
must first be defined and \strong{named} in the vegaspec.
These getter-functions are called from within
a Shiny \code{server()} function, where they act like
\code{\link[shiny:reactive]{shiny::reactive()}}, returning a reactive expression.
}
\details{
To see these functions in action, you can run a shiny-demo:
\itemize{
\item \code{vw_shiny_get_signal()}: call \code{vw_shiny_demo("signal-set-get")}
\item \code{vw_shiny_get_event()}: call \code{vw_shiny_demo("event-get")}
}

In addition to the chart \code{outputId}, you will need to provide:
\itemize{
\item \code{vw_shiny_get_signal()}: the \code{name} of the signal, as defined in the Vega
specification
\item \code{vw_shiny_get_event()}: the \code{event} type, as defined in the
\href{https://vega.github.io/vega/docs/event-streams/}{Vega Event-Stream reference}
}

When the signal changes, or when the event fires, Vega needs to know which
information you want returned to Shiny. To do this,
you provide a JavaScript handler-function:
\itemize{
\item \code{vw_shiny_get_signal()}: the default handler,
\code{vw_handler_signal("value")},
specifies that the value of the signal be returned.
\item \code{vw_shiny_get_event()}: the default handler,
\code{vw_handler_event("datum")},
specifies that the single row of data associated with graphical mark
be returned. For example, if you are monitoring a \code{"click"} event,
Vega would return the row of data that backs any mark
(like a point) that you click.
}

If you need to specify a different behavior for the handler, there are a
couple of options. This package provides
a library of handler-functions; call \code{\link[=vw_handler_signal]{vw_handler_signal()}},
\code{\link[=vw_handler_event]{vw_handler_event()}}, or without arguments to
list them.

If it does not contain the handler you need, the \code{body_value}
argument will also accept a character string which will be used as
the \strong{body} of the handler function.

For example, these calls are equivalent:
\itemize{
\item \code{vw_shiny_get_signal(..., body_value = "value")}
\item \code{vw_shiny_get_signal(..., body_value = vw_handler_signal("value"))}
\item \code{vw_shiny_get_signal(..., body_value = "return value;")}
}

If you use a custom-handler that you think may be useful for the
handler-function library, please
\href{https://github.com/vegawidget/vegawidget/issues}{file an issue}.
}
\seealso{
\code{\link[=vw_handler_signal]{vw_handler_signal()}}, \code{\link[=vw_handler_event]{vw_handler_event()}},
vega-view:
\href{https://github.com/vega/vega/tree/master/packages/vega-view#view_addSignalListener}{addSignalListener()},
\href{https://github.com/vega/vega/tree/master/packages/vega-view#view_addEventListener}{addEventListener()}
}
