% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vhist.R
\docType{methods}
\name{vhist}
\alias{vhist}
\title{Generate histogram with interactive functions}
\usage{
vhist(x, data, name, tag, path = tempdir(), ...)
}
\arguments{
\item{x}{column name of data frame \code{data} for drawing histogram}

\item{data}{data frame for default data set}

\item{name}{character for the name of the generated histogram}

\item{tag}{character for the common name of a series of linked plots}

\item{path}{character string of a directory for writing HTML and SVG files}

\item{...}{aesthetic mappings to be passed to ggplot2 methods}
}
\description{
\code{vscat} generates histogram of variable \code{x} of data frame \code{data} with interactive functions.
}
\examples{
\donttest{
data(vsfuk2012)
vhist(FertilityRate, vsfuk2012, "hist1", "vsfuk2012", fill=Type)
vlaunch(vsfuk2012, "main", "vsfuk2012", browse=FALSE)
}

}
