\name{sieveplot}
\alias{sieveplot}
\alias{sieveplot.default}
\alias{sieveplot.formula}
\title{Sieve Plots}
\description{
Visualization of two-way contingency tables: plots rectangles with surfaces
proportional to the expected cell frequencies and filled with a number of
squares equal to the expected frequencies. Thus, the densities visualize
the deviations of the observed from the expected values.
}
\usage{
\method{sieveplot}{default}(x, reverse.y = TRUE,
          type = c("sieve", "expected"), main = NULL,
          values = c("none", "cells", "margins", "both"),
          frequencies = c("absolute", "relative"),
          sieve.colors = c("red","blue"),
          sieve.lty = c("longdash", "solid"),
          exp.color = "gray", exp.lty = "dotted",
          margin = 0.01, cex.main = 2, cex.lab = 1.5,
          xlab = names(dimnames(x))[2],
          ylab = names(dimnames(x))[1], ...)
\method{sieveplot}{formula}(formula, data = NULL, ..., subset)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{a two-way contingency table, as generated by \code{table}.}
  \item{reverse.y}{if \code{TRUE}, the y axis is reversed (i.e., the
    rectangles' positions correspond to the contingency table).}
  \item{type}{\code{expected} fills the rectangles according to the
    \emph{expected} frequencies.}
  \item{main}{user specified title.}
  \item{values}{optionally, the frequencies of the \code{cells} or
    \code{margins} or of \code{both} can be plotted.}
  \item{frequencies}{chooses the type of these frequencies:
    \code{relative} or \code{absolute}.}
  \item{sieve.colors, sieve.lty}{vectors with up to two color/line type entries: the first
    is used for negative and the second for positive deviations
    from the expected frequencies.}
  \item{exp.color, exp.lty}{color/line type entry for the expected
    values grid.}
  \item{margin}{lines of margin between the cell rectangles.}
  \item{cex.main}{font size of title.}
  \item{cex.lab}{font size of labels.}
  \item{xlab, ylab}{labels of x- and y-axis.}
  \item{formula}{a formula, such as \code{y ~ x}. For details, see \code{xtabs}.}
  \item{data}{a data.frame (or list), or a contingency table from which the
          variables in `formula' should be taken.}
  \item{subset}{an optional vector specifying a subset of observations to be
    used for plotting.}
  \item{\dots}{further graphics parameters (see \code{par}).}
}
\references{
H. Riedwyl & M. Schpbach (1994), Parquet diagram to plot contingency tables.
In F. Faulbaum (ed.), \emph{Softstat '93: Advances in Statistical Software},
293-299. Gustav Fischer, New York.

M. Friendly (2000), Visualizing Categorical Data, SAS Institute, Cary, NC.
}
\author{
  David Meyer\cr
  \email{david.meyer@ci.tuwien.ac.at}
}
\seealso{\code{\link{mosaicplot}}}

\examples{
data(HairEyeColor)

## aggregate over `sex':
(tab <- margin.table(HairEyeColor, c(2,1)))

## plot expected values:
sieveplot(tab, type = "expected", values = "both")

## plot sieve diagram:
sieveplot(tab)

## an example for the formula interface:
data(VisualAcuity)
sieveplot(Freq ~ right + left,  data = VisualAcuity, reverse.y = FALSE)
}
\keyword{category}% at least one, from doc/KEYWORDS
\keyword{hplot}% __ONLY ONE__ keyword per line
